/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountHandleDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.HandleDiscountAdjustStrategy;
import com.biz.crm.dms.business.costpool.discount.sdk.vo.CostPoolDiscountVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CostPoolDiscountStrategyImpl
implements CostPoolStrategy {
    @Autowired(required=false)
    @Qualifier(value="CostPoolDiscountRegisterImpl")
    private CostPoolRegister costPoolRegister;
    @Autowired(required=false)
    private CostPoolDiscountService costPoolDiscountService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<HandleDiscountAdjustStrategy> handleDiscountAdjustStrategies;

    public String getPoolTypeRegisterKey() {
        return this.costPoolRegister.getKey();
    }

    public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
        List<CostPoolDiscount> byCustomerCode = this.costPoolDiscountService.findByCustomerCode(costPoolDto.getCustomerCode());
        if (CollectionUtils.isEmpty(byCustomerCode)) {
            return new ArrayList<CostPoolVo>(0);
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(byCustomerCode, CostPoolDiscount.class, CostPoolDiscountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void onHandleAdjust(JSONObject jsonObject) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.handleDiscountAdjustStrategies) ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u8fdb\u884c\u8c03\u6574\u65f6\uff0c\u4e3a\u83b7\u53d6\u5230\u8c03\u6574\u6ce8\u518c\u5668\uff01", (Object[])new Object[0]);
        CostPoolDiscountHandleDto costPoolDiscountHandleDto = (CostPoolDiscountHandleDto)JsonUtils.json2Obj((String)jsonObject.toJSONString(), CostPoolDiscountHandleDto.class);
        String operationType = costPoolDiscountHandleDto.getOperationType();
        PoolOperationTypeEnum operationTypeEnum = PoolOperationTypeEnum.getByKey((String)operationType);
        String operationTypeGroup = operationTypeEnum.getGroup();
        for (HandleDiscountAdjustStrategy handleDiscountAdjustStrategy : this.handleDiscountAdjustStrategies) {
            if (!handleDiscountAdjustStrategy.getOperationTypeGroup().equals(operationTypeGroup)) continue;
            handleDiscountAdjustStrategy.onHandleAdjust(costPoolDiscountHandleDto);
            break;
        }
    }
}

