package com.biz.crm.dms.business.costpool.discount.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 折扣费用池明细,按照租户进行隔离(CostPoolDiscountDetail)表相关的http接口
 *
 * @author songjingen
 * @since 2021-12-21 16:46:05
 */
@RestController
@RequestMapping("/v1/costPoolDiscount/costPoolDiscountDetail")
@Slf4j
@Api(tags = "折扣费用池明细:CostPoolDiscountDetail:折扣费用池明细")
public class CostPoolDiscountDetailController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private CostPoolDiscountDetailService costPoolDiscountDetailService;

  /**
   * 分页查询所有数据
   *
   * @param pageable               分页对象
   * @param costPoolDiscountDetail 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolDiscountDetail>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "costPoolDiscountDetail", value = "折扣费用池明细,按照租户进行隔离") CostPoolDiscountDetail costPoolDiscountDetail) {
    try {
      Page<CostPoolDiscountDetail> page = this.costPoolDiscountDetailService.findByConditions(pageable, costPoolDiscountDetail);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolDiscountDetail> findDetailsById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolDiscountDetail costPoolDiscountDetail = this.costPoolDiscountDetailService.findDetailsById(id);
      return Result.ok(costPoolDiscountDetail);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 调整折扣池明细
   *
   * @param costPoolDiscountDto
   * @return 新增结果
   */
  @ApiOperation(value = "调整折扣池明细")
  @PostMapping("handleAdjust")
  public Result<?> handleAdjust(@ApiParam(name = "CostPoolDiscount", value = "折扣池明细请求对象") @RequestBody CostPoolDiscountDto costPoolDiscountDto) {
    try {
      this.costPoolDiscountDetailService.handleAdjust(costPoolDiscountDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
