package com.biz.crm.dms.business.costpool.discount.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 折扣费用池明细记录表(CostPoolDiscountDetailLog)表相关的http接口
 *
 * @author songjingen
 * @since 2021-12-21 17:12:41
 */
@RestController
@RequestMapping("/v1/costPoolDiscount/costPoolDiscountDetailLog")
@Slf4j
@Api(tags = "折扣费用池明细记录:CostPoolDiscountDetailLog:折扣费用池明细记录")
public class CostPoolDiscountDetailLogController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;

  /**
   * 分页查询所有数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountDetailLog 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolDiscountDetailLog>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "costPoolDiscountDetailLog", value = "折扣费用池明细记录表") CostPoolDiscountDetailLog costPoolDiscountDetailLog) {
    try {
      Page<CostPoolDiscountDetailLog> page = this.costPoolDiscountDetailLogService.findByConditions(pageable, costPoolDiscountDetailLog);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolDiscountDetailLog> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolDiscountDetailLog costPoolDiscountDetailLog = this.costPoolDiscountDetailLogService.findById(id);
      return Result.ok(costPoolDiscountDetailLog);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param costPoolDiscountDetailLog 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<CostPoolDiscountDetailLog> create(@ApiParam(name = "costPoolDiscountDetailLog", value = "折扣费用池明细记录表") @RequestBody CostPoolDiscountDetailLog costPoolDiscountDetailLog) {
    try {
      CostPoolDiscountDetailLog result = this.costPoolDiscountDetailLogService.create(costPoolDiscountDetailLog);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
