package com.biz.crm.dms.business.costpool.discount.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 费用池附件表
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("dms_cost_pool_discount_file")
@Entity
@Table(name = "dms_cost_pool_discount_file", indexes = {@Index(name = "i_f_file_pool_code", columnList = "pool_code"),
    @Index(name = "i_f_file_operation_code", columnList = "operation_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_cost_pool_discount_file", comment = "费用池附件表")
public class CostPoolDiscountFile extends FileEntity {
  /**
   * 费用池编号
   */
  @Column(name = "pool_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池编号'")
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 操作记录编号
   */
  @Column(name = "operation_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作记录编号'")
  @ApiModelProperty(value = "操作记录编号")
  private String operationCode;


}
