package com.biz.crm.dms.business.costpool.discount.local.repository;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.mapper.CostPoolDiscountDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 折扣费用池明细,按照租户进行隔离(CostPoolDiscountDetail)表数据库访问层
 *
 * @author songjingen
 * @since 2021-12-21 16:46:05
 */
@Component
public class CostPoolDiscountDetailRepository extends ServiceImpl<CostPoolDiscountDetailMapper, CostPoolDiscountDetail> {

  @Autowired(required = false)
  private CostPoolDiscountDetailMapper costPoolDiscountDetailMapper;

  /**
   * 分页查询数据
   *
   * @param pageable               分页对象
   * @param costPoolDiscountDetail 实体对象
   * @return
   */
  public Page<CostPoolDiscountDetail> findByConditions(Pageable pageable, CostPoolDiscountDetail costPoolDiscountDetail) {
    Page<CostPoolDiscountDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolDiscountDetail> pageList = costPoolDiscountDetailMapper.findByConditions(page, costPoolDiscountDetail);
    return pageList;
  }

  /**
   * 根据费用池编码查询数据集合
   * @param poolCode
   * @return
   */
  public List<CostPoolDiscountDetail> findByPoolCode(String poolCode) {
    return this.lambdaQuery().eq(CostPoolDiscountDetail::getPoolCode, poolCode)
        .orderByAsc(CostPoolDiscountDetail::getAccountDateTime)
        .list();
  }

  /**
   * 根据费用池编码及来源编码查询（此方法用于审批通过时找到审批前占用的哪个就扣哪个）
   * @param poolCode 费用池编码
   * @param fromCode 来源编码
   * @return
   */
  public List<CostPoolDiscountDetail> findByPoolCodeAndFromCode(String poolCode, String fromCode) {
    return this.lambdaQuery()
        .eq(CostPoolDiscountDetail::getPoolCode, poolCode)
        .eq(CostPoolDiscountDetail::getFromCode, fromCode)
        .orderByAsc(CostPoolDiscountDetail::getAccountDateTime)
        .list();
  }

  /**
   * 根据折扣池明细编码查询数据
   * @param poolDetailCode
   * @return
   */
  public CostPoolDiscountDetail findByPoolDetailCode(String poolDetailCode) {
    return this.lambdaQuery().eq(CostPoolDiscountDetail::getPoolDetailCode, poolDetailCode).one();
  }

  /**
   * 根据折扣池明细编码查询数据
   * @param poolDetailCodes
   * @return
   */
  public List<CostPoolDiscountDetail> findByPoolDetailCodes(List<String> poolDetailCodes) {
    return this.lambdaQuery().in(CostPoolDiscountDetail::getPoolDetailCode, poolDetailCodes).list();
  }
}

