package com.biz.crm.dms.business.costpool.discount.local.repository;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.mapper.CostPoolDiscountFileMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 费用池附件表(CostPoolDiscountFile)表数据库访问层
 *
 * @author songjingen
 * @since 2021-12-21 17:13:57
 */
@Component
public class CostPoolDiscountFileRepository extends ServiceImpl<CostPoolDiscountFileMapper, CostPoolDiscountFile> {

  @Autowired(required = false)
  private CostPoolDiscountFileMapper costPoolDiscountFileMapper;

  /**
   * 分页查询数据
   *
   * @param pageable             分页对象
   * @param costPoolDiscountFile 实体对象
   * @return
   */
  public Page<CostPoolDiscountFile> findByConditions(Pageable pageable, CostPoolDiscountFile costPoolDiscountFile) {
    Page<CostPoolDiscountFile> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolDiscountFile> pageList = costPoolDiscountFileMapper.findByConditions(page, costPoolDiscountFile);
    return pageList;
  }
}

