package com.biz.crm.dms.business.costpool.discount.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.mapper.CostPoolDiscountOperationMapper;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.DiscountOperationCustomerDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;


/**
 * 费用池操作记录表实体类(CostPoolDiscountOperation)表数据库访问层
 *
 * @author songjingen
 * @since 2021-12-21 17:14:18
 */
@Component
public class CostPoolDiscountOperationRepository extends ServiceImpl<CostPoolDiscountOperationMapper, CostPoolDiscountOperation> {

  @Autowired(required = false)
  private CostPoolDiscountOperationMapper costPoolDiscountOperationMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountOperation 实体对象
   * @return
   */
  public Page<CostPoolDiscountOperation> findByConditions(Pageable pageable, CostPoolDiscountOperation costPoolDiscountOperation) {
    Page<CostPoolDiscountOperation> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolDiscountOperation> pageList = costPoolDiscountOperationMapper.findByConditions(page, costPoolDiscountOperation);
    return pageList;
  }

  /**
   * 客户-折扣操作明细分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<CostPoolDiscountOperation> findByDiscountOperationCustomerDto(Page<CostPoolDiscountOperation> page, DiscountOperationCustomerDto dto) {
    return this.costPoolDiscountOperationMapper.findByDiscountOperationCustomerDto(page, dto);
  }

  /**
   * 根据客户编码和始末时间查询集合
   *
   * @param customerCode 客户编码
   * @param beginDate    开始时间
   * @param endDate      结束时间
   * @return 集合
   */
  public List<CostPoolDiscountOperation> findByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
    return this.costPoolDiscountOperationMapper.findByCustomerCodeAndDate(customerCode, beginDate, endDate);
  }

  /**
   * 根据来源编码查询数据集合
   *
   * @param fromCode 来源编码
   * @return
   */
  public List<CostPoolDiscountOperation> findByFromCode(String fromCode) {
    return this.lambdaQuery()
        .eq(CostPoolDiscountOperation::getFromCode, fromCode)
        .list();
  }
}

