package com.biz.crm.dms.business.costpool.discount.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.mapper.CostPoolDiscountMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 折扣费用池，按照租户进行隔离(CostPoolDiscount)表数据库访问层
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
@Component
public class CostPoolDiscountRepository extends ServiceImpl<CostPoolDiscountMapper, CostPoolDiscount> {

  @Autowired(required = false)
  private CostPoolDiscountMapper CostPoolDiscountMapper;

  /**
   * 分页查询数据
   *
   * @param pageable         分页对象
   * @param costPoolDiscount 实体对象
   * @return
   */
  public Page<CostPoolDiscount> findByConditions(Pageable pageable, CostPoolDiscount costPoolDiscount) {
    Page<CostPoolDiscount> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolDiscount> pageList = CostPoolDiscountMapper.findByConditions(page, costPoolDiscount);
    return pageList;
  }

  /**
   * 根据费用池的相关类型查看
   *
   * @param useType
   * @param customerCode
   * @return
   */
  public CostPoolDiscount findByTypeAndCustomerCode(String useType, String customerCode) {
    return this.lambdaQuery()
        .eq(CostPoolDiscount::getUseType, useType)
        .eq(CostPoolDiscount::getCustomerCode, customerCode)
        .one();
  }

  /**
   * 通过费用池编码查询对象
   *
   * @param poolCode
   * @return
   */
  public CostPoolDiscount findByPoolCode(String poolCode) {
    return this.lambdaQuery().eq(CostPoolDiscount::getPoolCode, poolCode).one();
  }

  /**
   * 通过客户编码查询对象
   *
   * @param customerCode
   * @return
   */
  public List<CostPoolDiscount> findByCustomer(String customerCode) {
    return this.lambdaQuery()
        .eq(CostPoolDiscount::getCustomerCode, customerCode)
        .eq(CostPoolDiscount::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(CostPoolDiscount::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .orderByDesc(CostPoolDiscount::getCreateTime)
        .list();
  }
}

