package com.biz.crm.dms.business.costpool.discount.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import org.springframework.data.domain.Pageable;

/**
 * 费用池附件表(CostPoolDiscountFile)表服务接口
 *
 * @author songjingen
 * @since 2021-12-21 17:13:57
 */
public interface CostPoolDiscountFileService {

  /**
   * 分页查询数据
   *
   * @param pageable             分页对象
   * @param costPoolDiscountFile 实体对象
   * @return
   */
  Page<CostPoolDiscountFile> findByConditions(Pageable pageable, CostPoolDiscountFile costPoolDiscountFile);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolDiscountFile findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolDiscountFile 实体对象
   * @return 新增结果
   */
  CostPoolDiscountFile create(CostPoolDiscountFile costPoolDiscountFile);

}

