package com.biz.crm.dms.business.costpool.discount.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.DiscountOperationCustomerDto;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * 费用池操作记录表实体类(CostPoolDiscountOperation)表服务接口
 *
 * @author songjingen
 * @since 2021-12-21 17:14:18
 */
public interface CostPoolDiscountOperationService {

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountOperation 实体对象
   * @return
   */
  Page<CostPoolDiscountOperation> findByConditions(Pageable pageable, CostPoolDiscountOperation costPoolDiscountOperation);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolDiscountOperation findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolDiscountOperation 实体对象
   * @return 新增结果
   */
  CostPoolDiscountOperation create(CostPoolDiscountOperation costPoolDiscountOperation);

  /**
   * 客户-折扣操作明细分页查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CostPoolDiscountOperation> findByDiscountOperationCustomerDto(Pageable pageable, DiscountOperationCustomerDto dto);

  /**
   * 根据客户编码和始末时间查询集合
   *
   * @param customerCode 客户编码
   * @param beginDate    开始时间
   * @param endDate      结束时间
   * @return 集合
   */
  List<CostPoolDiscountOperation> findByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate);

  /**
   * 根据来源编码查询数据集合
   *
   * @param fromCode 来源编码
   * @return
   */
  List<CostPoolDiscountOperation> findByFromCode(String fromCode);
}

