package com.biz.crm.dms.business.costpool.discount.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountDetailLogRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 折扣费用池明细记录表(CostPoolDiscountDetailLog)表服务实现类
 *
 * @author songjingen
 * @since 2021-12-21 17:12:41
 */
@Service("costPoolDiscountDetailLogService")
public class CostPoolDiscountDetailLogServiceImpl implements CostPoolDiscountDetailLogService {

  @Autowired(required = false)
  private CostPoolDiscountDetailLogRepository costPoolDiscountDetailLogRepository;

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountDetailLog 实体对象
   * @return
   */
  @Override
  public Page<CostPoolDiscountDetailLog> findByConditions(Pageable pageable, CostPoolDiscountDetailLog costPoolDiscountDetailLog) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(costPoolDiscountDetailLog)) {
      costPoolDiscountDetailLog = new CostPoolDiscountDetailLog();
    }
    return this.costPoolDiscountDetailLogRepository.findByConditions(pageable, costPoolDiscountDetailLog);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CostPoolDiscountDetailLog findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.costPoolDiscountDetailLogRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param costPoolDiscountDetailLog 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CostPoolDiscountDetailLog create(CostPoolDiscountDetailLog costPoolDiscountDetailLog) {
    this.createValidate(costPoolDiscountDetailLog);
    this.costPoolDiscountDetailLogRepository.saveOrUpdate(costPoolDiscountDetailLog);
    return costPoolDiscountDetailLog;
  }

  @Override
  @Transactional
  public void createBatch(List<CostPoolDiscountDetailLog> detailLogList) {
    if (CollectionUtils.isEmpty(detailLogList)) {
      return;
    }
    for (CostPoolDiscountDetailLog costPoolDiscountDetailLog : detailLogList) {
      this.createValidate(costPoolDiscountDetailLog);
    }
    this.costPoolDiscountDetailLogRepository.saveBatch(detailLogList);
  }

  @Override
  public List<String> findPoolDetailCodeByFormCode(String poolCode, String fromCode) {
    return this.costPoolDiscountDetailLogRepository.findPoolDetailCodeByFormCode(poolCode,fromCode);
  }

  /**
   * 创建验证
   *
   * @param costPoolDiscountDetailLog
   */
  private void createValidate(CostPoolDiscountDetailLog costPoolDiscountDetailLog) {
    Validate.notNull(costPoolDiscountDetailLog, "新增时，对象信息不能为空！");
    costPoolDiscountDetailLog.setId(null);
    Validate.notNull(costPoolDiscountDetailLog.getOperationAmount(), "新增数据时，操作金额（数量）（含正负）不能为空！");
    Validate.notNull(costPoolDiscountDetailLog.getOperationCode(), "新增数据时，操作记录编号不能为空！");
    Validate.notNull(costPoolDiscountDetailLog.getOperationDateTime(), "新增数据时，操作时间 yyyy-MM-dd HH:mm:ss不能为空！");
    Validate.notNull(costPoolDiscountDetailLog.getOperationType(), "新增数据时，操作类型不能为空！");
    Validate.notNull(costPoolDiscountDetailLog.getPoolCode(), "新增数据时，费用池编号不能为空！");
    Validate.notNull(costPoolDiscountDetailLog.getPoolDetailCode(), "新增数据时，费用池明细编号不能为空！");

  }
}

