package com.biz.crm.dms.business.costpool.discount.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountFileRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountFileService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

/**
 * 费用池附件表(CostPoolDiscountFile)表服务实现类
 *
 * @author songjingen
 * @since 2021-12-21 17:13:57
 */
@Service("costPoolDiscountFileService")
public class CostPoolDiscountFileServiceImpl implements CostPoolDiscountFileService {

  @Autowired(required = false)
  private CostPoolDiscountFileRepository costPoolDiscountFileRepository;

  /**
   * 分页查询数据
   *
   * @param pageable             分页对象
   * @param costPoolDiscountFile 实体对象
   * @return
   */
  @Override
  public Page<CostPoolDiscountFile> findByConditions(Pageable pageable, CostPoolDiscountFile costPoolDiscountFile) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(costPoolDiscountFile)) {
      costPoolDiscountFile = new CostPoolDiscountFile();
    }
    return this.costPoolDiscountFileRepository.findByConditions(pageable, costPoolDiscountFile);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CostPoolDiscountFile findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.costPoolDiscountFileRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param costPoolDiscountFile 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CostPoolDiscountFile create(CostPoolDiscountFile costPoolDiscountFile) {
    this.createValidate(costPoolDiscountFile);
    this.costPoolDiscountFileRepository.saveOrUpdate(costPoolDiscountFile);
    return costPoolDiscountFile;
  }

  /**
   * 创建验证
   *
   * @param costPoolDiscountFile
   */
  private void createValidate(CostPoolDiscountFile costPoolDiscountFile) {
    Validate.notNull(costPoolDiscountFile, "新增时，对象信息不能为空！");
    costPoolDiscountFile.setId(null);
    Validate.notNull(costPoolDiscountFile.getOperationCode(), "新增数据时，操作记录编号不能为空！");
    Validate.notNull(costPoolDiscountFile.getPoolCode(), "新增数据时，费用池编号不能为空！");

  }
}

