package com.biz.crm.dms.business.costpool.discount.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountFileRepository;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountOperationRepository;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.sdk.constant.PoolDiscountConstant;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.DiscountOperationCustomerDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.CostPoolDiscountOperationGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 费用池操作记录表实体类(CostPoolDiscountOperation)表服务实现类
 *
 * @author songjingen
 * @since 2021-12-21 17:14:18
 */
@Service("costPoolDiscountOperationService")
public class CostPoolDiscountOperationServiceImpl implements CostPoolDiscountOperationService {

  @Autowired(required = false)
  private CostPoolDiscountOperationRepository costPoolDiscountOperationRepository;
  @Autowired(required = false)
  private CostPoolDiscountFileRepository costPoolDiscountFileRepository;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private CostPoolDiscountRepository costPoolDiscountRepository;

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountOperation 实体对象
   * @return
   */
  @Override
  public Page<CostPoolDiscountOperation> findByConditions(Pageable pageable, CostPoolDiscountOperation costPoolDiscountOperation) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(costPoolDiscountOperation)) {
      costPoolDiscountOperation = new CostPoolDiscountOperation();
    }
    return this.costPoolDiscountOperationRepository.findByConditions(pageable, costPoolDiscountOperation);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CostPoolDiscountOperation findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.costPoolDiscountOperationRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param costPoolDiscountOperation 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CostPoolDiscountOperation create(CostPoolDiscountOperation costPoolDiscountOperation) {
    this.createValidate(costPoolDiscountOperation);
    this.costPoolDiscountOperationRepository.saveOrUpdate(costPoolDiscountOperation);
    //新增附件
    Set<CostPoolDiscountFile> costPoolDiscountFiles = costPoolDiscountOperation.getCostPoolDiscountFiles();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      costPoolDiscountFiles.stream().forEach(costPoolDiscountFile -> {
        costPoolDiscountFile.setPoolCode(costPoolDiscountOperation.getPoolCode());
        costPoolDiscountFile.setOperationCode(costPoolDiscountOperation.getOperationCode());
        costPoolDiscountFile.setId(null);
      });
      this.costPoolDiscountFileRepository.saveBatch(costPoolDiscountFiles);
    }
    return costPoolDiscountOperation;
  }

  /**
   * 创建验证
   *
   * @param costPoolDiscountOperation
   */
  private void createValidate(CostPoolDiscountOperation costPoolDiscountOperation) {
    Validate.notNull(costPoolDiscountOperation, "新增时，对象信息不能为空！");
    costPoolDiscountOperation.setId(null);
    costPoolDiscountOperation.setOperationCode(generateCodeService.generateCode(PoolDiscountConstant.DISCOUNT_POOL_OPERATION, 1).get(0));
    Validate.notNull(costPoolDiscountOperation.getOperationAmount(), "新增数据时，操作金额（数量）（含正负）不能为空！");
    Validate.notNull(costPoolDiscountOperation.getOperationCode(), "新增数据时，操作记录编号不能为空！");
    Validate.notNull(costPoolDiscountOperation.getOperationDateTime(), "新增数据时，操作时间 yyyy-MM-dd HH:mm:ss不能为空！");
    Validate.notNull(costPoolDiscountOperation.getOperationType(), "新增数据时，操作类型不能为空！");
    Validate.notNull(costPoolDiscountOperation.getPoolCode(), "新增数据时，费用池编号不能为空！");

  }

  /**
   * 客户-折扣操作明细分页查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<CostPoolDiscountOperation> findByDiscountOperationCustomerDto(Pageable pageable, DiscountOperationCustomerDto dto) {
    String customerCode = dto.getCustomerCode();
    Page<CostPoolDiscountOperation> pageResultEmpty = new Page<>(0L, 0L, 0L);
    if (StringUtils.isBlank(customerCode)) {
      return pageResultEmpty;
    }
    //查询客户折扣池
    List<CostPoolDiscount> costPoolDiscountList = this.costPoolDiscountRepository
        .findByCustomer(customerCode);
    if (CollectionUtils.isEmpty(costPoolDiscountList)) {
      return pageResultEmpty;
    }
    CostPoolDiscount costPoolDiscount = costPoolDiscountList.get(0);
    dto.setPoolCode(costPoolDiscount.getPoolCode());
    Validate.notBlank(dto.getGroup(), "上账/使用标识不能为空");
    CostPoolDiscountOperationGroupEnum groupEnum = CostPoolDiscountOperationGroupEnum.getByKey(dto.getGroup());
    Validate.isTrue(!org.springframework.util.ObjectUtils.isEmpty(groupEnum), "上账/使用标识错误");
    List<String> operationTypeList = PoolOperationTypeEnum.getDictCodeByGroupEnum(groupEnum);
    dto.setOperationTypeList(operationTypeList);
    //查询
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<CostPoolDiscountOperation> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<CostPoolDiscountOperation> entityResult = this.costPoolDiscountOperationRepository
        .findByDiscountOperationCustomerDto(page, dto);
    return entityResult;
  }

  @Override
  public List<CostPoolDiscountOperation> findByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
    if (StringUtils.isBlank(customerCode) || (beginDate == null && endDate == null)) {
      return new ArrayList<>();
    }
    return this.costPoolDiscountOperationRepository.findByCustomerCodeAndDate(customerCode, beginDate, endDate);
  }

  @Override
  public List<CostPoolDiscountOperation> findByFromCode(String fromCode) {
    if (StringUtils.isAnyBlank(fromCode)) {
      return new ArrayList<>(0);
    }
    return this.costPoolDiscountOperationRepository.findByFromCode(fromCode);
  }
}

