package com.biz.crm.dms.business.costpool.discount.local.service.strategy;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 折扣费用池，上账操作类型组实现类
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
@Component
public class AccountOperationTypeStrategyImpl implements OperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolDiscountService costPoolDiscountService;
  @Autowired(required = false)
  private CostPoolDiscountDetailService costPoolDiscountDetailService;
  @Autowired(required = false)
  private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
  @Autowired(required = false)
  private CostPoolDiscountOperationService costPoolDiscountOperationService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.ACCOUNT.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
    /**
     * 1、创建折扣费用池
     * 2、创建操作记录
     * 3、创建明细
     * 4、创建明细记录
     */
    Date date = new Date();
    BigDecimal amount = costPoolDiscountDto.getAmount();
    //1、======
    CostPoolDiscount costPoolDiscount = new CostPoolDiscount();
    Validate.notBlank(costPoolDiscountDto.getUseType(), "进行上账时，使用类型不能为空！");
    Validate.notBlank(costPoolDiscountDto.getCustomerCode(), "进行上账时，客户编码不能为空！");
    CostPoolDiscount poolDiscount = this.costPoolDiscountService.findByTypeAndCustomerCode(costPoolDiscountDto.getUseType(), costPoolDiscountDto.getCustomerCode());
    if (!Objects.isNull(poolDiscount)) {
      //如果存在上账类型是期初的则不允许创建，否则可进行修改
      Validate.isTrue(!PoolOperationTypeEnum.INIT.getDictCode().equals(costPoolDiscountDto.getOperationType()), "上账类型为期初时，数据已存在不能再期初上账");
      //修改数据
      poolDiscount.setTotalAmount(poolDiscount.getTotalAmount().add(amount));
      poolDiscount.setUsableAmount(poolDiscount.getUsableAmount().add(amount));
      this.costPoolDiscountService.update(poolDiscount);
      costPoolDiscount = poolDiscount;
    } else {
      costPoolDiscount = this.nebulaToolkitService.copyObjectByWhiteList(costPoolDiscountDto, CostPoolDiscount.class, HashSet.class, ArrayList.class);
      costPoolDiscount.setPoolCode(String.valueOf(System.currentTimeMillis()));
      costPoolDiscount.setFreezeAmount(BigDecimal.ZERO);
      costPoolDiscount.setOccupyAmount(BigDecimal.ZERO);
      costPoolDiscount.setUsableAmount(amount);
      costPoolDiscount.setHasUseAmount(BigDecimal.ZERO);
      costPoolDiscount.setTotalAmount(amount);
      this.costPoolDiscountService.create(costPoolDiscount);
    }
    //2、======
    CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
    costPoolDiscountOperation.setPoolCode(costPoolDiscount.getPoolCode());
    costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
    costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
    costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
    costPoolDiscountOperation.setOperationDateTime(date);
    costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
    Set<CostPoolDiscountFileDto> costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolDiscountFile> files = (Set<CostPoolDiscountFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class);
      costPoolDiscountOperation.setCostPoolDiscountFiles(files);
    }
    costPoolDiscountOperationService.create(costPoolDiscountOperation);
    //3、======
    CostPoolDiscountDetail costPoolDiscountDetail = this.nebulaToolkitService.copyObjectByBlankList(costPoolDiscount, CostPoolDiscountDetail.class, HashSet.class, ArrayList.class, "id");
    costPoolDiscountDetail.setFromCode(costPoolDiscountDto.getFromCode());
    costPoolDiscountDetail.setFromDesc(costPoolDiscountDto.getFromDesc());
    costPoolDiscountDetail.setOperationType(costPoolDiscountDto.getOperationType());
    costPoolDiscountDetail.setOperationCode(costPoolDiscountOperation.getOperationCode());
    costPoolDiscountDetail.setAccountDateTime(date);
    costPoolDiscountDetail.setFreezeAmount(BigDecimal.ZERO);
    costPoolDiscountDetail.setOccupyAmount(BigDecimal.ZERO);
    costPoolDiscountDetail.setUsableAmount(amount);
    costPoolDiscountDetail.setHasUseAmount(BigDecimal.ZERO);
    costPoolDiscountDetail.setTotalAmount(amount);
    this.costPoolDiscountDetailService.create(costPoolDiscountDetail);
    //4、======
    CostPoolDiscountDetailLog costPoolDiscountDetailLog = this.nebulaToolkitService.copyObjectByBlankList(costPoolDiscountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, "id");
    costPoolDiscountDetailLog.setOperationDateTime(date);
    costPoolDiscountDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
    this.costPoolDiscountDetailLogService.create(costPoolDiscountDetailLog);
  }

  /**
   * 操作类型业务逻辑验证
   * todo 产品目前不要求校验
   *
   * @param operateType 操作类型
   * @param amount      操作金额
   * @param fromCode    退货编码
   */
  private void validateOperateTypeBusiness(String operateType, String fromCode, BigDecimal amount) {
    /**
     * 退货退款类型和订单关闭类型验证
     * 当前退货金额不能超过下订单金额
     */
    if (PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getDictCode().equals(operateType) || PoolOperationTypeEnum.ORDER_CLOSE.getDictCode().equals(operateType)) {
      Validate.notBlank(fromCode, "退货退款时，fromCode属性未赋值订单编码！");
      //根据订单编码和订单使用操作类型查询订单已使用的数据
      List<CostPoolDiscountOperation> orderUseOperations = this.costPoolDiscountOperationService.findByFromCode(fromCode);
      Validate.isTrue(!CollectionUtils.isEmpty(orderUseOperations), "退货退款时，未查询到订单编码为%s的数据！", fromCode);
      //按照操作类型分组计算金额
      Map<String, BigDecimal> collect = orderUseOperations.stream().collect(Collectors.groupingBy(CostPoolDiscountOperation::getOperationType, Collectors.reducing(BigDecimal.ZERO, CostPoolDiscountOperation::getOperationAmount, BigDecimal::add)));
      //取订单使用的金额，和退货退款的金额
      BigDecimal orderUseAmount = collect.get(PoolOperationTypeEnum.ORDER_USE.getDictCode());
      Validate.notNull(orderUseAmount, "退货退款时，当前订单%s未使用折扣费用！", fromCode);
      BigDecimal returnedGoodsAmount = collect.get(PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getDictCode());
      if (returnedGoodsAmount == null) {
        Validate.isTrue(orderUseAmount.add(amount).compareTo(BigDecimal.ZERO) <= 0, "退货退款时，当前订单%s的退款金额超过已使用折扣费用！", fromCode);
      } else {
        BigDecimal surplusOrderUseAmount = orderUseAmount.add(returnedGoodsAmount);
        Validate.isTrue(surplusOrderUseAmount.add(amount).compareTo(BigDecimal.ZERO) <= 0, "退货退款时，当前订单%s的退款金额超过已使用折扣费用！", fromCode);
      }
    }
  }
}

