package com.biz.crm.dms.business.costpool.discount.local.service.strategy;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 货补费用池，占用释放操作类型组实现类
 *
 * @author pengxi
 * @date 2022/6/21
 */
@Component
public class OccupyReleaseOperationTypeStrategyImpl implements OperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolDiscountRepository costPoolDiscountRepository;
  @Autowired(required = false)
  private CostPoolDiscountDetailService costPoolDiscountDetailService;
  @Autowired(required = false)
  private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
  @Autowired(required = false)
  private CostPoolDiscountOperationService costPoolDiscountOperationService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.OCCUPY_RELEASE.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
    /**
     * 1、修改费用池数据
     * 2、创建操作记录
     * 3、修改费用池明细数据，创建明细记录
     */
    Validate.notNull(costPoolDiscountDto.getPoolCode(), "进行占用释放时，费用池编码必传！");
    Validate.notNull(costPoolDiscountDto.getFromCode(), "进行占用释放时，来源编码必传！");
    Validate.notNull(costPoolDiscountDto.getFromDesc(), "进行占用释放时，来源描述必传！");
    Date date = new Date();
    BigDecimal amount = costPoolDiscountDto.getAmount();
    CostPoolDiscount poolDiscount = this.costPoolDiscountRepository.findByPoolCode(costPoolDiscountDto.getPoolCode());
    Validate.notNull(poolDiscount, "进行占用释放时未查询到信息");
    //1、======
    poolDiscount.setOccupyAmount(poolDiscount.getOccupyAmount().subtract(amount));
    poolDiscount.setUsableAmount(poolDiscount.getUsableAmount().add(amount));
    this.costPoolDiscountRepository.updateById(poolDiscount);
    //2、======
    CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
    costPoolDiscountOperation.setPoolCode(poolDiscount.getPoolCode());
    costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
    costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
    costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
    costPoolDiscountOperation.setOperationDateTime(new Date());
    costPoolDiscountOperation.setCreateTime(new Date());
    costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.OCCUPY_RELEASE.getUsableAmountWeight()));
    Set<CostPoolDiscountFileDto> costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolDiscountFile> files = (Set<CostPoolDiscountFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class);
      costPoolDiscountOperation.setCostPoolDiscountFiles(files);
    }
    costPoolDiscountOperationService.create(costPoolDiscountOperation);
    //3、======
    List<CostPoolDiscountDetail> discountDetailList = new ArrayList<>();
    List<CostPoolDiscountDetailLog> detailLogList = new ArrayList<>();
    List<CostPoolDiscountDetail> costPoolDiscountDetails = this.costPoolDiscountDetailService.findByPoolCodeAndFromCode(costPoolDiscountDto.getPoolCode(), costPoolDiscountDto.getFromCode());
    for (CostPoolDiscountDetail discountDetail : costPoolDiscountDetails) {
      if (amount.compareTo(BigDecimal.ZERO) <= 0) {
        break;
      }
      if (discountDetail.getOccupyAmount().compareTo(BigDecimal.ZERO) > 0) {
        BigDecimal itemUse = BigDecimal.ZERO;
        if (discountDetail.getOccupyAmount().compareTo(amount) >= 0) {
          itemUse = amount;
        } else {
          itemUse = discountDetail.getOccupyAmount();
        }
        amount = amount.subtract(itemUse);
        Validate.isTrue(discountDetail.getOccupyAmount().compareTo(itemUse) >= 0, "占用释放时金额不能超过占用金额");
        discountDetail.setOccupyAmount(discountDetail.getOccupyAmount().subtract(itemUse));
        discountDetail.setUsableAmount(discountDetail.getUsableAmount().add(itemUse));
        discountDetailList.add(discountDetail);
        //组装明细日志数据
        CostPoolDiscountDetailLog costPoolDiscountDetailLog = this.nebulaToolkitService.copyObjectByBlankList(discountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, "id");
        costPoolDiscountDetailLog.setOperationDateTime(date);
        costPoolDiscountDetailLog.setOperationCode(costPoolDiscountOperation.getOperationCode());
        costPoolDiscountDetailLog.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountDetailLog.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountDetailLog.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountDetailLog.setOperationAmount(itemUse.multiply(PoolOperationTypeGroupEnum.OCCUPY_RELEASE.getUsableAmountWeight()));
        detailLogList.add(costPoolDiscountDetailLog);
      }
    }
    Validate.isTrue(amount.compareTo(BigDecimal.ZERO) == 0, "占用释放金额不能超出占用金额");
    this.costPoolDiscountDetailService.updateBatch(discountDetailList);
    this.costPoolDiscountDetailLogService.createBatch(detailLogList);
  }
}

