package com.biz.crm.dms.business.costpool.discount.local.service.strategy.adjust;

import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountHandleDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.HandleDiscountAdjustStrategy;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 上账类触发调整注册器实现
 *
 * @author songjingen
 */
@Component
public class AccountHandleDiscountAdjustStrategy implements HandleDiscountAdjustStrategy {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  @Qualifier("accountOperationTypeStrategyImpl")
  private OperationTypeStrategy operationTypeStrategy;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.ACCOUNT.getValue();
  }

  @Override
  public void onHandleAdjust(CostPoolDiscountHandleDto costPoolDiscountHandleDto) {
    CostPoolDiscountDto costPoolDiscountDto = this.nebulaToolkitService.copyObjectByWhiteList(costPoolDiscountHandleDto, CostPoolDiscountDto.class, HashSet.class, ArrayList.class);
    this.operationTypeStrategy.onSaveDiscountInfos(costPoolDiscountDto);
  }
}
