package com.biz.crm.dms.business.costpool.discount.local.service.strategy.adjust;

import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountHandleDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.HandleDiscountAdjustStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 使用扣减类触发调整注册器实现
 *
 * @author songjingen
 */
@Component
public class UseHandleDiscountAdjustStrategy implements HandleDiscountAdjustStrategy {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private CostPoolDiscountService costPoolDiscountService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.USE.getValue();
  }

  @Override
  public void onHandleAdjust(CostPoolDiscountHandleDto costPoolDiscountHandleDto) {
    //查询客户对应的折扣池信息
    Validate.notBlank(costPoolDiscountHandleDto.getCustomerCode(), "触发折扣池调整时，未获取到客户编码！");
    List<CostPoolDiscount> costPoolDiscounts = this.costPoolDiscountService.findByCustomerCode(costPoolDiscountHandleDto.getCustomerCode());
    Validate.isTrue(!CollectionUtils.isEmpty(costPoolDiscounts), "触发折扣池调整时，为查询到当前客户对应的折扣信息！");
    BigDecimal amount = costPoolDiscountHandleDto.getAmount();
    BigDecimal remain = amount;
    for (CostPoolDiscount costPoolDiscount : costPoolDiscounts) {
      if (remain.compareTo(BigDecimal.ZERO) <= 0) {
        break;
      }
      CostPoolDiscountDto costPoolDiscountDto = this.nebulaToolkitService.copyObjectByWhiteList(costPoolDiscountHandleDto, CostPoolDiscountDto.class, HashSet.class, ArrayList.class);
      String poolCode = costPoolDiscount.getPoolCode();
      BigDecimal usableAmount = costPoolDiscount.getUsableAmount();
      if (remain.compareTo(usableAmount) >= 0) {
        costPoolDiscountDto.setAmount(usableAmount);
        remain = amount.subtract(usableAmount);
      } else {
        remain = BigDecimal.ZERO;
      }
      costPoolDiscountDto.setPoolCode(poolCode);
      this.costPoolDiscountService.handleAdjust(costPoolDiscountDto);
    }
  }
}
