package com.biz.crm.dms.business.costpool.discount.local.service.strategy.detail;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.DetailOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * 折扣费用池明细，上账操作类型组实现类
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
@Component
public class DetailAccountOperationTypeStrategyImpl implements DetailOperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolDiscountService costPoolDiscountService;
  @Autowired(required = false)
  private CostPoolDiscountDetailService costPoolDiscountDetailService;
  @Autowired(required = false)
  private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
  @Autowired(required = false)
  private CostPoolDiscountOperationService costPoolDiscountOperationService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.ACCOUNT.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
    /**
     * 1、修改折扣池明细
     * 2、修改折扣池
     * 3、创建操作记录
     * 4、创建明细记录
     */
    Date date = new Date();
    BigDecimal amount = costPoolDiscountDto.getAmount();
    //1、======
    Validate.notBlank(costPoolDiscountDto.getPoolDetailCode(), "进行上账时，费用池明细编码不能为空！");
    CostPoolDiscountDetail poolDiscountDetail = this.costPoolDiscountDetailService.findByPoolDetailCode(costPoolDiscountDto.getPoolDetailCode());
    Validate.notNull(poolDiscountDetail, "进行上账时，未查询到折扣池明细信息");
    poolDiscountDetail.setTotalAmount(poolDiscountDetail.getTotalAmount().add(amount));
    poolDiscountDetail.setUsableAmount(poolDiscountDetail.getUsableAmount().add(amount));
    this.costPoolDiscountDetailService.update(poolDiscountDetail);
    //2、======
    CostPoolDiscount costPoolDiscount = this.costPoolDiscountService.findByPoolCode(poolDiscountDetail.getPoolCode());
    Validate.notNull(costPoolDiscount, "进行上账时，未查询到折扣池信息");
    costPoolDiscount.setTotalAmount(costPoolDiscount.getTotalAmount().add(amount));
    costPoolDiscount.setUsableAmount(costPoolDiscount.getUsableAmount().add(amount));
    this.costPoolDiscountService.update(costPoolDiscount);
    //3、======
    CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
    costPoolDiscountOperation.setPoolCode(costPoolDiscount.getPoolCode());
    costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
    costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
    costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
    costPoolDiscountOperation.setOperationDateTime(date);
    costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
    Set<CostPoolDiscountFileDto> costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolDiscountFile> files = (Set<CostPoolDiscountFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class);
      costPoolDiscountOperation.setCostPoolDiscountFiles(files);
    }
    costPoolDiscountOperationService.create(costPoolDiscountOperation);
    //4、======
    CostPoolDiscountDetailLog costPoolDiscountDetailLog = this.nebulaToolkitService.copyObjectByBlankList(poolDiscountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, "id");
    costPoolDiscountDetailLog.setOperationDateTime(date);
    costPoolDiscountDetailLog.setOperationCode(costPoolDiscountOperation.getOperationCode());
    costPoolDiscountDetailLog.setOperationType(costPoolDiscountDto.getOperationType());
    costPoolDiscountDetailLog.setFromCode(costPoolDiscountDto.getFromCode());
    costPoolDiscountDetailLog.setFromDesc(costPoolDiscountDto.getFromDesc());
    costPoolDiscountDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
    this.costPoolDiscountDetailLogService.create(costPoolDiscountDetailLog);
  }
}

