/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.observer;

import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.sdk.enums.CostPoolSummaryEnum;
import com.biz.crm.dms.business.costpool.sdk.observer.CostPoolAmountStatisticsObserver;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="CostPoolAmountStatisticsDiscountObserver")
public class CostPoolAmountStatisticsDiscountObserver
implements CostPoolAmountStatisticsObserver {
    @Autowired(required=false)
    private CostPoolDiscountOperationService costPoolDiscountOperationService;
    @Autowired(required=false)
    @Qualifier(value="CostPoolDiscountRegisterImpl")
    private CostPoolRegister costPoolRegister;

    public List<CostPoolAmountStatisticsVo> findAmountStatisticsVoByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
        if (StringUtils.isBlank((CharSequence)customerCode) || beginDate == null || endDate == null) {
            return new ArrayList<CostPoolAmountStatisticsVo>();
        }
        ArrayList<CostPoolAmountStatisticsVo> costPoolAmountStatisticsVos = new ArrayList<CostPoolAmountStatisticsVo>();
        BigDecimal beginAmount = BigDecimal.ZERO;
        List<CostPoolDiscountOperation> beginList = this.costPoolDiscountOperationService.findByCustomerCodeAndDate(customerCode, null, beginDate);
        if (CollectionUtils.isNotEmpty(beginList)) {
            beginAmount = beginList.stream().map(CostPoolDiscountOperation::getOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        CostPoolAmountStatisticsVo costPoolAmountStatisticsVo = new CostPoolAmountStatisticsVo();
        costPoolAmountStatisticsVo.setPoolType(this.costPoolRegister.getKey());
        costPoolAmountStatisticsVo.setSummary(CostPoolSummaryEnum.BEGIN.getKey());
        costPoolAmountStatisticsVo.setTotalAmount(beginAmount.abs());
        costPoolAmountStatisticsVos.add(costPoolAmountStatisticsVo);
        List<CostPoolDiscountOperation> onAndUseList = this.costPoolDiscountOperationService.findByCustomerCodeAndDate(customerCode, beginDate, endDate);
        BigDecimal onAmount = BigDecimal.ZERO;
        BigDecimal useAmount = BigDecimal.ZERO;
        BigDecimal occupyAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(onAndUseList)) {
            for (CostPoolDiscountOperation costPoolDiscountOperation : onAndUseList) {
                String operationType = costPoolDiscountOperation.getOperationType();
                BigDecimal operationAmount = costPoolDiscountOperation.getOperationAmount();
                if (StringUtils.isBlank((CharSequence)operationType)) continue;
                String groupKey = PoolOperationTypeEnum.getByKey((String)operationType).getGroupEnum().getFlagCode();
                if (groupKey.equals(CostPoolSummaryEnum.ON.getDictCode())) {
                    onAmount = onAmount.add(operationAmount);
                    continue;
                }
                if (groupKey.equals(CostPoolSummaryEnum.USE.getDictCode())) {
                    useAmount = useAmount.add(operationAmount);
                    continue;
                }
                if (!groupKey.equals(CostPoolSummaryEnum.OCCUPY.getDictCode())) continue;
                occupyAmount = occupyAmount.add(operationAmount);
            }
        }
        CostPoolAmountStatisticsVo on = new CostPoolAmountStatisticsVo();
        on.setPoolType(this.costPoolRegister.getKey());
        on.setSummary(CostPoolSummaryEnum.ON.getKey());
        on.setTotalAmount(onAmount.abs());
        costPoolAmountStatisticsVos.add(on);
        CostPoolAmountStatisticsVo use = new CostPoolAmountStatisticsVo();
        use.setPoolType(this.costPoolRegister.getKey());
        use.setSummary(CostPoolSummaryEnum.USE.getKey());
        use.setTotalAmount(useAmount.abs());
        costPoolAmountStatisticsVos.add(use);
        CostPoolAmountStatisticsVo occupy = new CostPoolAmountStatisticsVo();
        occupy.setPoolType(this.costPoolRegister.getKey());
        occupy.setSummary(CostPoolSummaryEnum.OCCUPY.getKey());
        occupy.setTotalAmount(occupyAmount.abs());
        costPoolAmountStatisticsVos.add(occupy);
        BigDecimal endAmount = beginAmount.add(onAmount).add(useAmount);
        CostPoolAmountStatisticsVo end = new CostPoolAmountStatisticsVo();
        end.setPoolType(this.costPoolRegister.getKey());
        end.setSummary(CostPoolSummaryEnum.END.getKey());
        end.setTotalAmount(endAmount.abs());
        costPoolAmountStatisticsVos.add(end);
        return costPoolAmountStatisticsVos;
    }
}

