/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.strategy;

import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AccountOperationTypeStrategyImpl
implements OperationTypeStrategy {
    @Autowired(required=false)
    private CostPoolDiscountService costPoolDiscountService;
    @Autowired(required=false)
    private CostPoolDiscountDetailService costPoolDiscountDetailService;
    @Autowired(required=false)
    private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
    @Autowired(required=false)
    private CostPoolDiscountOperationService costPoolDiscountOperationService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.ACCOUNT.getValue();
    }

    @Transactional
    public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
        Date date = new Date();
        BigDecimal amount = costPoolDiscountDto.getAmount();
        CostPoolDiscount costPoolDiscount = new CostPoolDiscount();
        Validate.notBlank((CharSequence)costPoolDiscountDto.getUseType(), (String)"\u8fdb\u884c\u4e0a\u8d26\u65f6\uff0c\u4f7f\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscountDto.getCustomerCode(), (String)"\u8fdb\u884c\u4e0a\u8d26\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CostPoolDiscount poolDiscount = this.costPoolDiscountService.findByTypeAndCustomerCode(costPoolDiscountDto.getUseType(), costPoolDiscountDto.getCustomerCode());
        if (!Objects.isNull((Object)poolDiscount)) {
            Validate.isTrue((!PoolOperationTypeEnum.INIT.getDictCode().equals(costPoolDiscountDto.getOperationType()) ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u7c7b\u578b\u4e3a\u671f\u521d\u65f6\uff0c\u6570\u636e\u5df2\u5b58\u5728\u4e0d\u80fd\u518d\u671f\u521d\u4e0a\u8d26", (Object[])new Object[0]);
            poolDiscount.setTotalAmount(poolDiscount.getTotalAmount().add(amount));
            poolDiscount.setUsableAmount(poolDiscount.getUsableAmount().add(amount));
            this.costPoolDiscountService.update(poolDiscount);
            costPoolDiscount = poolDiscount;
        } else {
            costPoolDiscount = (CostPoolDiscount)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)costPoolDiscountDto, CostPoolDiscount.class, HashSet.class, ArrayList.class, new String[0]));
            costPoolDiscount.setPoolCode(String.valueOf(System.currentTimeMillis()));
            costPoolDiscount.setFreezeAmount(BigDecimal.ZERO);
            costPoolDiscount.setOccupyAmount(BigDecimal.ZERO);
            costPoolDiscount.setUsableAmount(amount);
            costPoolDiscount.setHasUseAmount(BigDecimal.ZERO);
            costPoolDiscount.setTotalAmount(amount);
            this.costPoolDiscountService.create(costPoolDiscount);
        }
        CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
        costPoolDiscountOperation.setPoolCode(costPoolDiscount.getPoolCode());
        costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountOperation.setOperationDateTime(date);
        costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        Set costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
        if (!CollectionUtils.isEmpty((Collection)costPoolDiscountFiles)) {
            Set files = (Set)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class, new String[0]);
            costPoolDiscountOperation.setCostPoolDiscountFiles(files);
        }
        this.costPoolDiscountOperationService.create(costPoolDiscountOperation);
        CostPoolDiscountDetail costPoolDiscountDetail = (CostPoolDiscountDetail)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)costPoolDiscount, CostPoolDiscountDetail.class, HashSet.class, ArrayList.class, new String[]{"id"}));
        costPoolDiscountDetail.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountDetail.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountDetail.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountDetail.setOperationCode(costPoolDiscountOperation.getOperationCode());
        costPoolDiscountDetail.setAccountDateTime(date);
        costPoolDiscountDetail.setFreezeAmount(BigDecimal.ZERO);
        costPoolDiscountDetail.setOccupyAmount(BigDecimal.ZERO);
        costPoolDiscountDetail.setUsableAmount(amount);
        costPoolDiscountDetail.setHasUseAmount(BigDecimal.ZERO);
        costPoolDiscountDetail.setTotalAmount(amount);
        this.costPoolDiscountDetailService.create(costPoolDiscountDetail);
        CostPoolDiscountDetailLog costPoolDiscountDetailLog = (CostPoolDiscountDetailLog)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)costPoolDiscountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, new String[]{"id"}));
        costPoolDiscountDetailLog.setOperationDateTime(date);
        costPoolDiscountDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        this.costPoolDiscountDetailLogService.create(costPoolDiscountDetailLog);
    }

    private void validateOperateTypeBusiness(String operateType, String fromCode, BigDecimal amount) {
        if (PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getDictCode().equals(operateType) || PoolOperationTypeEnum.ORDER_CLOSE.getDictCode().equals(operateType)) {
            Validate.notBlank((CharSequence)fromCode, (String)"\u9000\u8d27\u9000\u6b3e\u65f6\uff0cfromCode\u5c5e\u6027\u672a\u8d4b\u503c\u8ba2\u5355\u7f16\u7801\uff01", (Object[])new Object[0]);
            List<CostPoolDiscountOperation> orderUseOperations = this.costPoolDiscountOperationService.findByFromCode(fromCode);
            Validate.isTrue((!CollectionUtils.isEmpty(orderUseOperations) ? 1 : 0) != 0, (String)"\u9000\u8d27\u9000\u6b3e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\uff01", (Object[])new Object[]{fromCode});
            Map<String, BigDecimal> collect = orderUseOperations.stream().collect(Collectors.groupingBy(CostPoolDiscountOperation::getOperationType, Collectors.reducing(BigDecimal.ZERO, CostPoolDiscountOperation::getOperationAmount, BigDecimal::add)));
            BigDecimal orderUseAmount = collect.get(PoolOperationTypeEnum.ORDER_USE.getDictCode());
            Validate.notNull((Object)orderUseAmount, (String)"\u9000\u8d27\u9000\u6b3e\u65f6\uff0c\u5f53\u524d\u8ba2\u5355%s\u672a\u4f7f\u7528\u6298\u6263\u8d39\u7528\uff01", (Object[])new Object[]{fromCode});
            BigDecimal returnedGoodsAmount = collect.get(PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getDictCode());
            if (returnedGoodsAmount == null) {
                Validate.isTrue((orderUseAmount.add(amount).compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)"\u9000\u8d27\u9000\u6b3e\u65f6\uff0c\u5f53\u524d\u8ba2\u5355%s\u7684\u9000\u6b3e\u91d1\u989d\u8d85\u8fc7\u5df2\u4f7f\u7528\u6298\u6263\u8d39\u7528\uff01", (Object[])new Object[]{fromCode});
            } else {
                BigDecimal surplusOrderUseAmount = orderUseAmount.add(returnedGoodsAmount);
                Validate.isTrue((surplusOrderUseAmount.add(amount).compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)"\u9000\u8d27\u9000\u6b3e\u65f6\uff0c\u5f53\u524d\u8ba2\u5355%s\u7684\u9000\u6b3e\u91d1\u989d\u8d85\u8fc7\u5df2\u4f7f\u7528\u6298\u6263\u8d39\u7528\uff01", (Object[])new Object[]{fromCode});
            }
        }
    }
}

