/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.strategy;

import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UseOperationTypeStrategyImpl
implements OperationTypeStrategy {
    @Autowired(required=false)
    private CostPoolDiscountRepository costPoolDiscountRepository;
    @Autowired(required=false)
    private CostPoolDiscountDetailService costPoolDiscountDetailService;
    @Autowired(required=false)
    private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
    @Autowired(required=false)
    private CostPoolDiscountOperationService costPoolDiscountOperationService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.USE.getValue();
    }

    @Transactional
    public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
        List<CostPoolDiscountDetail> costPoolDiscountDetails;
        Validate.notNull((Object)costPoolDiscountDto.getPoolCode(), (String)"\u8fdb\u884c\u4f7f\u7528\u6263\u51cf\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u5fc5\u4f20\uff01", (Object[])new Object[0]);
        Date date = new Date();
        BigDecimal amount = costPoolDiscountDto.getAmount();
        CostPoolDiscount poolDiscount = this.costPoolDiscountRepository.findByPoolCode(costPoolDiscountDto.getPoolCode());
        Validate.notNull((Object)((Object)poolDiscount), (String)"\u8fdb\u884c\u6263\u51cf\u65f6\u672a\u67e5\u8be2\u5230\u4fe1\u606f", (Object[])new Object[0]);
        poolDiscount.setHasUseAmount(poolDiscount.getHasUseAmount().add(amount));
        poolDiscount.setUsableAmount(poolDiscount.getUsableAmount().subtract(amount));
        this.costPoolDiscountRepository.updateById((Object)poolDiscount);
        CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
        costPoolDiscountOperation.setPoolCode(poolDiscount.getPoolCode());
        costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
        Date now = new Date();
        Date afterDate = new Date(now.getTime() + 3000L);
        costPoolDiscountOperation.setCreateTime(afterDate);
        costPoolDiscountOperation.setOperationDateTime(afterDate);
        costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        Set costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
        if (!CollectionUtils.isEmpty((Collection)costPoolDiscountFiles)) {
            Set files = (Set)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class, new String[0]);
            costPoolDiscountOperation.setCostPoolDiscountFiles(files);
        }
        this.costPoolDiscountOperationService.create(costPoolDiscountOperation);
        ArrayList<CostPoolDiscountDetail> discountDetailList = new ArrayList<CostPoolDiscountDetail>();
        ArrayList<CostPoolDiscountDetailLog> detailLogList = new ArrayList<CostPoolDiscountDetailLog>();
        if (StringUtils.isNotBlank((CharSequence)costPoolDiscountDto.getFromCode())) {
            List<String> byFormCode = this.costPoolDiscountDetailLogService.findPoolDetailCodeByFormCode(costPoolDiscountDto.getPoolCode(), costPoolDiscountDto.getFromCode());
            Validate.notEmpty(byFormCode, (String)String.format("%s\u8ba2\u5355\u672a\u4f7f\u7528", costPoolDiscountDto.getFromCode()), (Object[])new Object[0]);
            costPoolDiscountDetails = this.costPoolDiscountDetailService.findByPoolDetailCodes(byFormCode);
        } else {
            costPoolDiscountDetails = this.costPoolDiscountDetailService.findByPoolCode(poolDiscount.getPoolCode());
        }
        for (CostPoolDiscountDetail discountDetail : costPoolDiscountDetails) {
            if (amount.compareTo(BigDecimal.ZERO) <= 0) break;
            BigDecimal usableAmount = discountDetail.getUsableAmount();
            if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = usableAmount.compareTo(amount) >= 0 ? amount : usableAmount;
            amount = amount.subtract(itemUse);
            Validate.isTrue((usableAmount.compareTo(itemUse) >= 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6263\u51cf\u65f6\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u7528\u91d1\u989d", (Object[])new Object[0]);
            discountDetail.setUsableAmount(usableAmount.subtract(itemUse));
            discountDetail.setHasUseAmount(discountDetail.getHasUseAmount().add(itemUse));
            discountDetailList.add(discountDetail);
            CostPoolDiscountDetailLog costPoolDiscountDetailLog = (CostPoolDiscountDetailLog)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)discountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, new String[]{"id"}));
            costPoolDiscountDetailLog.setOperationDateTime(date);
            costPoolDiscountDetailLog.setOperationCode(costPoolDiscountOperation.getOperationCode());
            costPoolDiscountDetailLog.setOperationType(costPoolDiscountDto.getOperationType());
            costPoolDiscountDetailLog.setFromCode(costPoolDiscountDto.getFromCode());
            costPoolDiscountDetailLog.setFromDesc(costPoolDiscountDto.getFromDesc());
            costPoolDiscountDetailLog.setOperationAmount(itemUse.multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
            detailLogList.add(costPoolDiscountDetailLog);
        }
        Validate.isTrue((amount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6c60\u6263\u51cf\u5f02\u5e38", (Object[])new Object[0]);
        this.costPoolDiscountDetailService.updateBatch(discountDetailList);
        this.costPoolDiscountDetailLogService.createBatch(detailLogList);
    }
}

