/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.strategy.adjust;

import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountHandleDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.HandleDiscountAdjustStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UseHandleDiscountAdjustStrategy
implements HandleDiscountAdjustStrategy {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CostPoolDiscountService costPoolDiscountService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.USE.getValue();
    }

    public void onHandleAdjust(CostPoolDiscountHandleDto costPoolDiscountHandleDto) {
        BigDecimal amount;
        Validate.notBlank((CharSequence)costPoolDiscountHandleDto.getCustomerCode(), (String)"\u89e6\u53d1\u6298\u6263\u6c60\u8c03\u6574\u65f6\uff0c\u672a\u83b7\u53d6\u5230\u5ba2\u6237\u7f16\u7801\uff01", (Object[])new Object[0]);
        List<CostPoolDiscount> costPoolDiscounts = this.costPoolDiscountService.findByCustomerCode(costPoolDiscountHandleDto.getCustomerCode());
        Validate.isTrue((!CollectionUtils.isEmpty(costPoolDiscounts) ? 1 : 0) != 0, (String)"\u89e6\u53d1\u6298\u6263\u6c60\u8c03\u6574\u65f6\uff0c\u4e3a\u67e5\u8be2\u5230\u5f53\u524d\u5ba2\u6237\u5bf9\u5e94\u7684\u6298\u6263\u4fe1\u606f\uff01", (Object[])new Object[0]);
        BigDecimal remain = amount = costPoolDiscountHandleDto.getAmount();
        for (CostPoolDiscount costPoolDiscount : costPoolDiscounts) {
            if (remain.compareTo(BigDecimal.ZERO) <= 0) break;
            CostPoolDiscountDto costPoolDiscountDto = (CostPoolDiscountDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)costPoolDiscountHandleDto, CostPoolDiscountDto.class, HashSet.class, ArrayList.class, new String[0]);
            String poolCode = costPoolDiscount.getPoolCode();
            BigDecimal usableAmount = costPoolDiscount.getUsableAmount();
            if (remain.compareTo(usableAmount) >= 0) {
                costPoolDiscountDto.setAmount(usableAmount);
                remain = amount.subtract(usableAmount);
            } else {
                remain = BigDecimal.ZERO;
            }
            costPoolDiscountDto.setPoolCode(poolCode);
            this.costPoolDiscountService.handleAdjust(costPoolDiscountDto);
        }
    }
}

