/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.strategy.detail;

import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.DetailOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class DetailAccountOperationTypeStrategyImpl
implements DetailOperationTypeStrategy {
    @Autowired(required=false)
    private CostPoolDiscountService costPoolDiscountService;
    @Autowired(required=false)
    private CostPoolDiscountDetailService costPoolDiscountDetailService;
    @Autowired(required=false)
    private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
    @Autowired(required=false)
    private CostPoolDiscountOperationService costPoolDiscountOperationService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.ACCOUNT.getValue();
    }

    @Transactional
    public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
        Date date = new Date();
        BigDecimal amount = costPoolDiscountDto.getAmount();
        Validate.notBlank((CharSequence)costPoolDiscountDto.getPoolDetailCode(), (String)"\u8fdb\u884c\u4e0a\u8d26\u65f6\uff0c\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CostPoolDiscountDetail poolDiscountDetail = this.costPoolDiscountDetailService.findByPoolDetailCode(costPoolDiscountDto.getPoolDetailCode());
        Validate.notNull((Object)((Object)poolDiscountDetail), (String)"\u8fdb\u884c\u4e0a\u8d26\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6298\u6263\u6c60\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        poolDiscountDetail.setTotalAmount(poolDiscountDetail.getTotalAmount().add(amount));
        poolDiscountDetail.setUsableAmount(poolDiscountDetail.getUsableAmount().add(amount));
        this.costPoolDiscountDetailService.update(poolDiscountDetail);
        CostPoolDiscount costPoolDiscount = this.costPoolDiscountService.findByPoolCode(poolDiscountDetail.getPoolCode());
        Validate.notNull((Object)((Object)costPoolDiscount), (String)"\u8fdb\u884c\u4e0a\u8d26\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6298\u6263\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        costPoolDiscount.setTotalAmount(costPoolDiscount.getTotalAmount().add(amount));
        costPoolDiscount.setUsableAmount(costPoolDiscount.getUsableAmount().add(amount));
        this.costPoolDiscountService.update(costPoolDiscount);
        CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
        costPoolDiscountOperation.setPoolCode(costPoolDiscount.getPoolCode());
        costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountOperation.setOperationDateTime(date);
        costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        Set costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
        if (!CollectionUtils.isEmpty((Collection)costPoolDiscountFiles)) {
            Set files = (Set)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class, new String[0]);
            costPoolDiscountOperation.setCostPoolDiscountFiles(files);
        }
        this.costPoolDiscountOperationService.create(costPoolDiscountOperation);
        CostPoolDiscountDetailLog costPoolDiscountDetailLog = (CostPoolDiscountDetailLog)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)poolDiscountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, new String[]{"id"}));
        costPoolDiscountDetailLog.setOperationDateTime(date);
        costPoolDiscountDetailLog.setOperationCode(costPoolDiscountOperation.getOperationCode());
        costPoolDiscountDetailLog.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountDetailLog.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountDetailLog.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        this.costPoolDiscountDetailLogService.create(costPoolDiscountDetailLog);
    }
}

