/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.strategy.detail;

import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.DetailOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class DetailUnFreezeOperationTypeStrategyImpl
implements DetailOperationTypeStrategy {
    @Autowired(required=false)
    private CostPoolDiscountService costPoolDiscountService;
    @Autowired(required=false)
    private CostPoolDiscountDetailService costPoolDiscountDetailService;
    @Autowired(required=false)
    private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
    @Autowired(required=false)
    private CostPoolDiscountOperationService costPoolDiscountOperationService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.UNFREEZE.getValue();
    }

    @Transactional
    public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
        Validate.notNull((Object)costPoolDiscountDto.getPoolDetailCode(), (String)"\u8fdb\u884c\u89e3\u51bb\u65f6\uff0c\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u7801\u5fc5\u4f20\uff01", (Object[])new Object[0]);
        Date date = new Date();
        BigDecimal amount = costPoolDiscountDto.getAmount();
        CostPoolDiscountDetail poolDiscountDetail = this.costPoolDiscountDetailService.findByPoolDetailCode(costPoolDiscountDto.getPoolDetailCode());
        Validate.notNull((Object)((Object)poolDiscountDetail), (String)"\u8fdb\u884c\u89e3\u51bb\u65f6\u672a\u67e5\u8be2\u5230\u6298\u6263\u6c60\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((poolDiscountDetail.getFreezeAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u89e3\u51bb\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u6298\u6263\u6c60\u660e\u7ec6\u51bb\u7ed3\u91d1\u989d", (Object[])new Object[0]);
        poolDiscountDetail.setFreezeAmount(poolDiscountDetail.getFreezeAmount().subtract(amount));
        poolDiscountDetail.setUsableAmount(poolDiscountDetail.getUsableAmount().add(amount));
        this.costPoolDiscountDetailService.update(poolDiscountDetail);
        CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
        costPoolDiscountOperation.setPoolCode(poolDiscountDetail.getPoolCode());
        costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountOperation.setOperationDateTime(date);
        costPoolDiscountOperation.setOperationAmount(costPoolDiscountDto.getAmount().multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        Set costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
        if (!CollectionUtils.isEmpty((Collection)costPoolDiscountFiles)) {
            Set files = (Set)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class, new String[0]);
            costPoolDiscountOperation.setCostPoolDiscountFiles(files);
        }
        this.costPoolDiscountOperationService.create(costPoolDiscountOperation);
        CostPoolDiscount costPoolDiscount = this.costPoolDiscountService.findByPoolCode(poolDiscountDetail.getPoolCode());
        Validate.notNull((Object)((Object)costPoolDiscount), (String)"\u8fdb\u884c\u89e3\u51bb\u65f6\u672a\u67e5\u8be2\u5230\u6298\u6263\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((costPoolDiscount.getFreezeAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u89e3\u51bb\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u6298\u6263\u6c60\u51bb\u7ed3\u91d1\u989d", (Object[])new Object[0]);
        costPoolDiscount.setFreezeAmount(costPoolDiscount.getFreezeAmount().subtract(amount));
        costPoolDiscount.setUsableAmount(costPoolDiscount.getUsableAmount().add(amount));
        this.costPoolDiscountService.update(costPoolDiscount);
        CostPoolDiscountDetailLog costPoolDiscountDetailLog = (CostPoolDiscountDetailLog)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)poolDiscountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, new String[]{"id"}));
        costPoolDiscountDetailLog.setOperationDateTime(date);
        costPoolDiscountDetailLog.setOperationCode(costPoolDiscountOperation.getOperationCode());
        costPoolDiscountDetailLog.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountDetailLog.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountDetailLog.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        this.costPoolDiscountDetailLogService.create(costPoolDiscountDetailLog);
    }
}

