package com.biz.crm.dms.business.costpool.discount.sdk.dto;

import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 折扣费用池
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "折扣费用池Dto")
public class CostPoolDiscountDto extends CostPoolDto {

  /**
   * 费用池分组
   */
  @ApiModelProperty(value = "费用池分组")
  private String poolGroup;
  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 费用池明细编号
   */
  @ApiModelProperty(value = "费用池明细编号")
  private String poolDetailCode;
  /**
   * 支付方式
   */
  @ApiModelProperty(value = "支付方式")
  private String payType;
  /**
   * 费用使用类型
   */
  @ApiModelProperty(value = "费用使用类型")
  private String useType;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String customerName;
  /**
   * 操作类型
   * {@link PoolOperationTypeEnum#getKey()}
   */
  @ApiModelProperty(value = "操作类型")
  private String operationType;

  /**
   * 备注
   */
  @ApiModelProperty(value = "备注")
  private String remark;
  /**
   * 附件信息集合
   */
  @ApiModelProperty("附件信息集合")
  private Set<CostPoolDiscountFileDto> costPoolDiscountFiles;
}
