package com.biz.crm.dms.business.costpool.discount.sdk.dto;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 折扣费用池
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "折扣费用池Dto")
public class CostPoolDiscountHandleDto extends CostPoolDto {

  /**
   * 费用使用类型
   */
  @ApiModelProperty(value = "费用使用类型")
  private String useType;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String customerName;
  /**
   * 操作类型
   */
  @ApiModelProperty(value = "操作类型")
  private String operationType;

  /**
   * 备注
   */
  @ApiModelProperty(value = "备注")
  private String remark;
  /**
   * 支付方式
   */
  @ApiModelProperty(value = "支付方式")
  private String payType;
  /**
   * 附件信息集合
   */
  @ApiModelProperty("附件信息集合")
  private Set<CostPoolDiscountFileDto> costPoolDiscountFiles;
}
