package com.biz.crm.dms.business.costpool.discount.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.discount.sdk.dto
 * @ClassName DiscountOperationCustomerDto
 * @Author YangWei
 * @Date 2022/3/23 上午11:21
 * @Description 折扣操作明细dto
 */
@Data
@ApiModel(value = "DiscountOperationCustomerDto", description = "商城查询资金明细dto")
public class DiscountOperationCustomerDto extends TenantDto {

  @ApiModelProperty(value = "费用池编号")
  private String poolCode;

  /**
   * 操作明细大类（上账/使用）
   */
  @ApiModelProperty(name = "group", value = "操作明细大类（上账/使用)", required = true)
  private String group;

  /** 操作类型集合 */
  @ApiModelProperty(name = "operationTypeList", value = "操作类型")
  private List<String> operationTypeList;

  /**
   * 查询期间开始时间
   */
  @ApiModelProperty("查询期间开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 查询期间结束时间
   */
  @ApiModelProperty("查询期间结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
}