package com.biz.crm.dms.business.costpool.discount.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description 折扣池操作分组
 * @Author YangWei
 * @Date Created in 2022/3/23 上午11:39
 */
public enum CostPoolDiscountOperationGroupEnum {
  /**
   * 上账
   */
  ON("1", "1", "ON", "上账", "1"),

  /**
   * 使用
   */
  USE("2", "2", "USE", "使用", "2"),

  /**
   * 占用
   */
  OCCUPY("3", "3", "OCCUPY", "占用", "3"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * flag编码
   */
  private String flagCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CostPoolDiscountOperationGroupEnum(String key, String dictCode, String flagCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
    this.flagCode = flagCode;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  public String getFlagCode() {
    return flagCode;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static CostPoolDiscountOperationGroupEnum getByKey(String key) {
    return Arrays.stream(CostPoolDiscountOperationGroupEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
