package com.biz.crm.dms.business.costpool.discount.sdk.enums;


import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 费用池操作类型枚举
 *
 * @author songjingen
 */
public enum PoolOperationTypeEnum {

  INIT("1", "1", "期初", "1", "account", CostPoolDiscountOperationGroupEnum.ON),
  MANUAL_ACCOUNT("2", "2", "手动上账", "2", "account", CostPoolDiscountOperationGroupEnum.ON),
  REBATE_ACCOUNT("3", "3", "返利上账", "3", "account", CostPoolDiscountOperationGroupEnum.ON),
  MANUAL_INDUCE("5", "5", "手动扣减", "5", "use", CostPoolDiscountOperationGroupEnum.USE),
  ORDER_USE("6", "6", "订单使用", "6", "use", CostPoolDiscountOperationGroupEnum.USE),
  FREEZE("7", "7", "冻结", "7", "freeze", CostPoolDiscountOperationGroupEnum.ON),
  UNFREEZE("8", "8", "解冻", "8", "unfreeze", CostPoolDiscountOperationGroupEnum.ON),
  ACT_ACCOUNT("9", "9", "活动上账", "9", "account", CostPoolDiscountOperationGroupEnum.ON),
  RETURNED_GOODS_AMOUNT("10", "10", "退货退款", "10", "account", CostPoolDiscountOperationGroupEnum.ON),
  ORDER_CLOSE("11", "11", "订单关闭", "11", "account", CostPoolDiscountOperationGroupEnum.ON),
  OCCUPY_USE("12", "12", "占用", "12", "occupy_use", CostPoolDiscountOperationGroupEnum.OCCUPY),
  OCCUPY_RELEASE("13", "13", "释放", "13", "occupy_release", CostPoolDiscountOperationGroupEnum.OCCUPY),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
  /**
   * 操作分组
   */
  private String group;

  /**
   * 操作类型分组上账/使用
   */
  private CostPoolDiscountOperationGroupEnum groupEnum;

  PoolOperationTypeEnum(String key, String dictCode, String value, String order, String group, CostPoolDiscountOperationGroupEnum groupEnum) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
    this.group = group;
    this.groupEnum = groupEnum;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getGroup() {
    return group;
  }

  public String getOrder() {
    return order;
  }

  public CostPoolDiscountOperationGroupEnum getGroupEnum() {
    return groupEnum;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static PoolOperationTypeEnum getByKey(String key) {
    return Arrays.stream(PoolOperationTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过大类获取折扣操作类型集合
   *
   * @param groupEnum
   * @return
   */
  public static List<String> getDictCodeByGroupEnum(CostPoolDiscountOperationGroupEnum groupEnum) {
    List<String> groupTypeList = Arrays.stream(PoolOperationTypeEnum.values())
        .filter(item -> Objects.equals(item.getGroupEnum(), groupEnum))
        .map(PoolOperationTypeEnum::getDictCode)
        .collect(Collectors.toList());
    return groupTypeList;
  }
}


