package com.biz.crm.dms.business.costpool.discount.sdk.strategy;

import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountHandleDto;

/**
 * 出发调整是所用到的策略类,以客户为维度去进行调整折扣池
 *
 * @author songjingen
 */
public interface HandleDiscountAdjustStrategy {

  /**
   * 操作类型分组编码
   *
   * @return
   */
  String getOperationTypeGroup();

  /**
   * 当需要具体的操作类型分组进行保存的折扣池信息的维护时，该方法会被触发
   *
   * @param costPoolDiscountHandleDto 折扣池请求信息
   * @return
   */
  void onHandleAdjust(CostPoolDiscountHandleDto costPoolDiscountHandleDto);
}
