package com.biz.crm.dms.business.costpool.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 费用池基础模块相关http请求
 *
 * @author songjingen
 */
@RestController
@RequestMapping("/v1/costPool/costPoolVo")
@Api(tags = "费用池基础:CostPoolVo:费用池基础")
@Slf4j
public class CostPoolVoController {

  @Autowired(required = false)
  private CostPoolVoService costPoolVoService;

  /**
   * 触发查询费用池余额
   *
   * @param costPoolDto
   * @return
   */
  @GetMapping("handleRequestCostPoolVos")
  @ApiOperation(value = "触发查询费用池余额")
  public Result<List<CostPoolVo>> handleRequestCostPoolVos(CostPoolDto costPoolDto) {
    try {
      List<CostPoolVo> costPoolVos = this.costPoolVoService.handleRequestCostPoolVos(costPoolDto);
      return Result.ok(costPoolVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 触发调整费用池通用接口
   *
   * @param jsonArray
   * @return
   */
  @PatchMapping("handleAdjust")
  @ApiOperation(value = "触发调整费用池通用接口")
  public Result<?> handleAdjust(@RequestBody JSONArray jsonArray) {
    try {
      this.costPoolVoService.handleAdjust(jsonArray);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据用户编码查询余额
   *
   * @param customerCode
   * @return
   */
  @GetMapping("findUsableAmountByCustomerCodeStuMap")
  @ApiOperation(value = "根据用户编码查询余额,以费用池类型为key，余额为value的map")
  public Result<Map<String, BigDecimal>> findUsableAmountByCustomerCodeStuMap(@RequestParam String customerCode) {
    try {
      Map<String, BigDecimal> map = this.costPoolVoService.findUsableAmountByCustomerCodeStuMap(customerCode);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
