package com.biz.crm.dms.business.costpool.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolAmountStatisticsVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 费用池统计相关http请求
 *
 * @author songjingen
 */
@RestController
@RequestMapping("/v1/costPool/CostPoolAmountStatisticsVo")
@Api(tags = "费用池基础:CostPoolAmountStatisticsVo:费用池基础")
@Slf4j
public class CostPoolAmountStatisticsVoController {

  @Autowired(required = false)
  private CostPoolAmountStatisticsVoService costPoolAmountStatisticsVoService;

  /**
   * 按照客户编码和日期范围统计，以mapKey为key，统计的金额集合为value
   *
   * @param
   * @return
   */
  @GetMapping("handleAmountStatisticsByCustomerCodeAndDate")
  @ApiOperation(value = "按照客户编码和日期范围统计，以mapKey为key，统计的金额集合为value")
  public Result<Map<String, List<CostPoolAmountStatisticsVo>>> handleAmountStatisticsByCustomerCodeAndDateForPoolTypeKey(@ApiParam(name = "customerCode", value = "客户编码") @RequestParam String customerCode,
                                                                                                                         @ApiParam(name = "beginDate", value = "开始时间") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @RequestParam Date beginDate,
                                                                                                                         @ApiParam(name = "endDate", value = "结束时间") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @RequestParam Date endDate,
                                                                                                                         @ApiParam(name = "mapKey", value = "map的key：summary-摘要，poolType-费用池") @RequestParam String mapKey) {
    try {
      Map<String, List<CostPoolAmountStatisticsVo>> stringListMap = this.costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, beginDate, endDate, mapKey);
      return Result.ok(stringListMap);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
