package com.biz.crm.dms.business.costpool.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.sdk.model.CostPoolModel;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 费用池注册模型相关http请求
 *
 * @author songjingen
 */
@RestController
@RequestMapping("/v1/costPool/costPoolModel")
@Api(tags = "费用池基础:costPoolModel:费用池注册模型")
@Slf4j
public class CostPoolModelController {

  @Autowired(required = false)
  private CostPoolVoService costPoolVoService;

  /**
   * 查询费所有费用池模型
   *
   * @return
   */
  @GetMapping("findCostPoolModel")
  @ApiOperation(value = "查询费所有费用池模型")
  public Result<List<CostPoolModel>> findCostPoolModel() {
    try {
      List<CostPoolModel> costPoolModels = this.costPoolVoService.findCostPoolModel();
      return Result.ok(costPoolModels);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
