package com.biz.crm.dms.business.costpool.local.service.internal;

import com.biz.crm.dms.business.costpool.sdk.observer.CostPoolAmountStatisticsObserver;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolAmountStatisticsVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 根据摘要统计不同操作类型的金额
 *
 * @author songjingen
 */
@Service
public class CostPoolAmountStatisticsVoServiceImpl implements CostPoolAmountStatisticsVoService {

  private final static String SUMMARY_KEY = "summary";
  private final static String POOL_TYPE_KEY = "poolType";

  @Autowired(required = false)
  private List<CostPoolAmountStatisticsObserver> costPoolAmountStatisticsObservers;

  @Override
  public Map<String, List<CostPoolAmountStatisticsVo>> handleAmountStatisticsByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate, String mapKey) {
    if (StringUtils.isBlank(customerCode) || beginDate == null || endDate == null || CollectionUtils.isEmpty(costPoolAmountStatisticsObservers)) {
      return new HashMap<>();
    }
    ArrayList<CostPoolAmountStatisticsVo> costPoolAmountStatisticsVos = new ArrayList<>();
    for (CostPoolAmountStatisticsObserver costPoolAmountStatisticsObserver : costPoolAmountStatisticsObservers) {
      List<CostPoolAmountStatisticsVo> amountStatisticsVoByCustomerCodeAndDate = costPoolAmountStatisticsObserver.findAmountStatisticsVoByCustomerCodeAndDate(customerCode, beginDate, endDate);
      if (CollectionUtils.isNotEmpty(amountStatisticsVoByCustomerCodeAndDate)) {
        costPoolAmountStatisticsVos.addAll(amountStatisticsVoByCustomerCodeAndDate);
      }
    }
    if (CollectionUtils.isEmpty(costPoolAmountStatisticsVos)) {
      return new HashMap<>();
    }
    //按照摘要分组
    if (SUMMARY_KEY.equals(mapKey)) {
      return costPoolAmountStatisticsVos.stream().filter(a -> StringUtils.isNotBlank(a.getSummary())).collect(Collectors.groupingBy(CostPoolAmountStatisticsVo::getSummary));
    }
    //按照费用池类型分组
    if (POOL_TYPE_KEY.equals(mapKey)) {
      return costPoolAmountStatisticsVos.stream().filter(a -> StringUtils.isNotBlank(a.getPoolType())).collect(Collectors.groupingBy(CostPoolAmountStatisticsVo::getPoolType));
    }
    //都不匹配则按照摘要分组
    return costPoolAmountStatisticsVos.stream().filter(a -> StringUtils.isNotBlank(a.getSummary())).collect(Collectors.groupingBy(CostPoolAmountStatisticsVo::getSummary));
  }
}
