/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/costPool/costPoolVo"})
@Api(tags={"\u8d39\u7528\u6c60\u57fa\u7840:CostPoolVo:\u8d39\u7528\u6c60\u57fa\u7840"})
public class CostPoolVoController {
    private static final Logger log = LoggerFactory.getLogger(CostPoolVoController.class);
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;

    @GetMapping(value={"handleRequestCostPoolVos"})
    @ApiOperation(value="\u89e6\u53d1\u67e5\u8be2\u8d39\u7528\u6c60\u4f59\u989d")
    public Result<List<CostPoolVo>> handleRequestCostPoolVos(CostPoolDto costPoolDto) {
        try {
            List costPoolVos = this.costPoolVoService.handleRequestCostPoolVos(costPoolDto);
            return Result.ok((Object)costPoolVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"handleAdjust"})
    @ApiOperation(value="\u89e6\u53d1\u8c03\u6574\u8d39\u7528\u6c60\u901a\u7528\u63a5\u53e3")
    public Result<?> handleAdjust(@RequestBody JSONArray jsonArray) {
        try {
            this.costPoolVoService.handleAdjust(jsonArray);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findUsableAmountByCustomerCodeStuMap"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u7f16\u7801\u67e5\u8be2\u4f59\u989d,\u4ee5\u8d39\u7528\u6c60\u7c7b\u578b\u4e3akey\uff0c\u4f59\u989d\u4e3avalue\u7684map")
    public Result<Map<String, BigDecimal>> findUsableAmountByCustomerCodeStuMap(@RequestParam String customerCode) {
        try {
            Map map = this.costPoolVoService.findUsableAmountByCustomerCodeStuMap(customerCode);
            return Result.ok((Object)map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

