/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.local.service.internal;

import com.biz.crm.dms.business.costpool.sdk.observer.CostPoolAmountStatisticsObserver;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolAmountStatisticsVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CostPoolAmountStatisticsVoServiceImpl
implements CostPoolAmountStatisticsVoService {
    private static final String SUMMARY_KEY = "summary";
    private static final String POOL_TYPE_KEY = "poolType";
    @Autowired(required=false)
    private List<CostPoolAmountStatisticsObserver> costPoolAmountStatisticsObservers;

    public Map<String, List<CostPoolAmountStatisticsVo>> handleAmountStatisticsByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate, String mapKey) {
        if (StringUtils.isBlank((CharSequence)customerCode) || beginDate == null || endDate == null || CollectionUtils.isEmpty(this.costPoolAmountStatisticsObservers)) {
            return new HashMap<String, List<CostPoolAmountStatisticsVo>>();
        }
        ArrayList costPoolAmountStatisticsVos = new ArrayList();
        for (CostPoolAmountStatisticsObserver costPoolAmountStatisticsObserver : this.costPoolAmountStatisticsObservers) {
            List amountStatisticsVoByCustomerCodeAndDate = costPoolAmountStatisticsObserver.findAmountStatisticsVoByCustomerCodeAndDate(customerCode, beginDate, endDate);
            if (!CollectionUtils.isNotEmpty((Collection)amountStatisticsVoByCustomerCodeAndDate)) continue;
            costPoolAmountStatisticsVos.addAll(amountStatisticsVoByCustomerCodeAndDate);
        }
        if (CollectionUtils.isEmpty(costPoolAmountStatisticsVos)) {
            return new HashMap<String, List<CostPoolAmountStatisticsVo>>();
        }
        if (SUMMARY_KEY.equals(mapKey)) {
            return costPoolAmountStatisticsVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSummary())).collect(Collectors.groupingBy(CostPoolAmountStatisticsVo::getSummary));
        }
        if (POOL_TYPE_KEY.equals(mapKey)) {
            return costPoolAmountStatisticsVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPoolType())).collect(Collectors.groupingBy(CostPoolAmountStatisticsVo::getPoolType));
        }
        return costPoolAmountStatisticsVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSummary())).collect(Collectors.groupingBy(CostPoolAmountStatisticsVo::getSummary));
    }
}

