/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.model.CostPoolModel;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CostPoolVoServiceImpl
implements CostPoolVoService {
    @Autowired(required=false)
    private List<CostPoolStrategy> costPoolStrategies;
    @Autowired(required=false)
    private List<CostPoolRegister> costPoolRegisters;

    public List<CostPoolVo> handleRequestCostPoolVos(CostPoolDto costPoolDto) {
        if (Objects.isNull(costPoolDto) || CollectionUtils.isEmpty(this.costPoolStrategies)) {
            return null;
        }
        String poolType = costPoolDto.getPoolType();
        List<Object> costPoolVos = new ArrayList<CostPoolVo>();
        for (CostPoolStrategy costPoolStrategy : this.costPoolStrategies) {
            String poolTypeRegisterKey = costPoolStrategy.getPoolTypeRegisterKey();
            if (!StringUtils.equals((CharSequence)poolType, (CharSequence)poolTypeRegisterKey)) continue;
            costPoolVos = costPoolStrategy.onRequestCostPoolVos(costPoolDto);
            break;
        }
        return costPoolVos;
    }

    @Transactional
    public void handleAdjust(JSONArray jsonArray) {
        Validate.isTrue((jsonArray != null && jsonArray.size() > 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u8d39\u7528\u6c60\u4fe1\u606f\u65f6\uff0c\u5165\u53c2json\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.costPoolStrategies) ? 1 : 0) != 0, (String)"\u8c03\u6574\u8d39\u7528\u6c60\u4fe1\u606f\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8d39\u7528\u6c60\u57fa\u7840\u6a21\u5757\u89c2\u5bdf\u8005\u5b9e\u73b0\u7c7b", (Object[])new Object[0]);
        block0: for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String poolType = jsonObject.getString("poolType");
            for (CostPoolStrategy costPoolStrategy : this.costPoolStrategies) {
                String poolTypeRegisterKey = costPoolStrategy.getPoolTypeRegisterKey();
                if (!StringUtils.equals((CharSequence)poolType, (CharSequence)poolTypeRegisterKey)) continue;
                costPoolStrategy.onHandleAdjust(jsonObject);
                continue block0;
            }
        }
    }

    public List<CostPoolModel> findCostPoolModel() {
        if (CollectionUtils.isEmpty(this.costPoolRegisters)) {
            return new ArrayList<CostPoolModel>();
        }
        ArrayList costPoolModels = Lists.newArrayList();
        for (CostPoolRegister costPoolRegister : this.costPoolRegisters) {
            CostPoolModel costPoolModel = new CostPoolModel();
            costPoolModel.setKey(costPoolRegister.getKey());
            costPoolModel.setName(costPoolRegister.getName());
            costPoolModels.add(costPoolModel);
        }
        return costPoolModels;
    }

    public Map<String, BigDecimal> findUsableAmountByCustomerCodeStuMap(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode) || CollectionUtils.isEmpty(this.costPoolStrategies)) {
            return null;
        }
        List<CostPoolModel> costPoolModel = this.findCostPoolModel();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (CostPoolModel poolModel : costPoolModel) {
            CostPoolDto costPoolDto = new CostPoolDto();
            costPoolDto.setPoolType(poolModel.getKey());
            costPoolDto.setCustomerCode(customerCode);
            BigDecimal amount = BigDecimal.ZERO;
            List<CostPoolVo> costPoolVos = this.handleRequestCostPoolVos(costPoolDto);
            if (!CollectionUtils.isEmpty(costPoolVos)) {
                amount = costPoolVos.stream().map(CostPoolVo::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            map.put(poolModel.getKey(), amount);
        }
        return map;
    }
}

