package com.biz.crm.dms.business.costpool.replenishment.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.feign.feign.CostPoolReplenishmentVoServiceFeign;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年06月21日 14:35:00
 */
@Component
@Slf4j
public class CostPoolReplenishmentVoServiceFeignImpl implements FallbackFactory<CostPoolReplenishmentVoServiceFeign> {

  @Override
  public CostPoolReplenishmentVoServiceFeign create(Throwable cause) {
    log.error("进入CostPoolReplenishmentVoServiceFeign熔断", cause);
    return new CostPoolReplenishmentVoServiceFeign() {
      @Override
      public Result<?> handleAdjust(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        throw new UnsupportedOperationException("货补费用池调整熔断");
      }
    };
  }
}
