package com.biz.crm.dms.business.costpool.replenishment.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.feign.feign.internal.CostPoolReplenishmentVoServiceFeignImpl;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年06月21日 14:35:00
 */
@FeignClient(
    name = "${dms.feign-client.name:crm-dms}",
    path = "crm-dms",
    fallbackFactory = CostPoolReplenishmentVoServiceFeignImpl.class)
public interface CostPoolReplenishmentVoServiceFeign {

  @PostMapping("/v1/replenishment/costPoolReplenishment/handleAdjust")
  Result<?> handleAdjust(@ApiParam(name = "CostPoolDiscount", value = "折扣池请求对象") @RequestBody  CostPoolReplenishmentDto costPoolReplenishmentDto);
}
