package com.biz.crm.dms.business.costpool.replenishment.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 货补费用池明细(CostPoolReplenishmentDetail)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishmentDetail")
@Slf4j
@Api(tags = "货补费用池明细:CostPoolReplenishmentDetail:货补费用池明细")
public class CostPoolReplenishmentDetailController {
  /**
  * 服务对象
  */
  @Autowired(required = false)
  private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param costPoolReplenishmentDetail 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolReplenishmentDetail>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                    @ApiParam(name = "costPoolReplenishmentDetail", value = "货补费用池明细") CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
    try {
      Page<CostPoolReplenishmentDetail> page = this.costPoolReplenishmentDetailService.findByConditions(pageable, costPoolReplenishmentDetail);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolReplenishmentDetail> findDetailsById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolReplenishmentDetail costPoolReplenishmentDetail = this.costPoolReplenishmentDetailService.findDetailsById(id);
      return Result.ok(costPoolReplenishmentDetail);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentDetail 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<CostPoolReplenishmentDetail> create(@ApiParam(name = "costPoolReplenishmentDetail", value = "货补费用池明细") @RequestBody CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
    try {
      CostPoolReplenishmentDetail result = this.costPoolReplenishmentDetailService.create(costPoolReplenishmentDetail);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 调整货补池
   *
   * @param costPoolReplenishmentDto 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "调整货补池")
  @PostMapping("handleAdjust")
  public Result<?> handleAdjust(@ApiParam(name = "CostPoolDiscount", value = "货补池请求对象") @RequestBody CostPoolReplenishmentDto costPoolReplenishmentDto) {
    try {
      this.costPoolReplenishmentDetailService.handleAdjust(costPoolReplenishmentDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
