package com.biz.crm.dms.business.costpool.replenishment.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOperationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.replenishment.local.controller
 * @ClassName CostPoolReplenishmentOperationVoController
 * @Author YangWei
 * @Date 2022/3/23 下午2:39
 * @Description 货补费用池操作记录Vo接口
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishmentOperation")
@Slf4j
@Api(tags = "货补费用池操作记录表:CostPoolReplenishmentOperationVo:货补费用池操作记录表")
public class CostPoolReplenishmentOperationVoController {

  @Autowired(required = false)
  private CostPoolReplenishmentOperationVoService costPoolReplenishmentOperationVoService;

  /**
   * 客户-货补操作明细分页查询
   *
   * @param pageable
   * @param dto
   */
  @ApiOperation(value = "客户-货补操作明细分页查询")
  @GetMapping("/findByCostPoolReplenishmentOperationDto")
  public Result<Page<CostPoolReplenishmentOperationVo>> findByCostPoolReplenishmentOperationDto(
      @PageableDefault(50) Pageable pageable, CostPoolReplenishmentOperationDto dto) {
    return Result.ok(this.costPoolReplenishmentOperationVoService.findByCostPoolReplenishmentOperationDto(pageable, dto));
  }
}