package com.biz.crm.dms.business.costpool.replenishment.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentOrderVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOrderPageDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HanJiaJun
 * @describe:用于订单新增货补产品时提供接口
 * @createTime 2022年03月08日 17:32:00
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishment")
@Slf4j
@Api(tags = "用于订单新增货补产品时提供接口")
public class CostPoolReplenishmentOrderVoController {


  @Autowired(required = false)
  private CostPoolReplenishmentOrderVoService costPoolReplenishmentOrderVoService;

  /**
   * 分页查询所有数据 用于新增订单时查询相关货补池商品
   *
   * @param pageable              分页对象
   * @param costPoolReplenishmentOrderPageDto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据(用于新增订单时查询相关货补池商品)")
  @GetMapping("findByReplenishmentPageDto")
  public Result<Page<CostPoolReplenishmentOrderVo>> findByReplenishmentPageDto(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                       @ApiParam(name = "costPoolReplenishment", value = "货补费用池主表") CostPoolReplenishmentOrderPageDto costPoolReplenishmentOrderPageDto) {
    try {
      Page<CostPoolReplenishmentOrderVo> page = this.costPoolReplenishmentOrderVoService.findByReplenishmentPageDto(pageable, costPoolReplenishmentOrderPageDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
