package com.biz.crm.dms.business.costpool.replenishment.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentStatisticalVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentStatisticalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 用于商城端 统计货补池提供接口
 * @createTime 2022年06月01日 10:45:00
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishment")
@Slf4j
@Api(tags = "统计货补池提供接口")
public class CostPoolReplenishmentStatisticalVoController {

  @Autowired(required = false)
  private CostPoolReplenishmentStatisticalVoService costPoolReplenishmentStatisticalVoService;


  @GetMapping("statisticsByCustomerCodeAndDate")
  @ApiOperation(value = "按照客户编码和日期范围统计，统计金额")
  public Result<List<CostPoolReplenishmentStatisticalVo>> statisticsByCustomerCodeAndDate(
      @ApiParam(name = "customerCode", value = "客户编码") @RequestParam String customerCode,
      @ApiParam(name = "beginDate", value = "开始时间") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @RequestParam Date beginDate,
      @ApiParam(name = "endDate", value = "结束时间") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") @RequestParam Date endDate) {
    try {
      List<CostPoolReplenishmentStatisticalVo> stringListMap = this.costPoolReplenishmentStatisticalVoService.statisticsByCustomerCodeAndDate(customerCode, beginDate, endDate);
      return Result.ok(stringListMap);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
