package com.biz.crm.dms.business.costpool.replenishment.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * @author HanJiaJun
 * @describe:货补费用池明细
 * @createTime 2021年12月27日 17:23:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("dms_cost_pool_replenishment_detail")
@Entity
@Table(name = "dms_cost_pool_replenishment_detail", indexes = {
    @Index(columnList = "pool_detail_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_cost_pool_replenishment_detail", comment = "货补费用池明细")
public class CostPoolReplenishmentDetail extends TenantFlagOpEntity {
  /**
   * 费用池编号
   */
  @Column(name = "pool_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池编号'")
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 费用池明细编号
   */
  @Column(name = "pool_detail_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池明细编号'")
  @ApiModelProperty(value = "费用池明细编号")
  private String poolDetailCode;
  /**
   * 操作记录编号
   */
  @Column(name = "operation_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作记录编号'")
  @ApiModelProperty(value = "操作记录编号")
  private String operationCode;
  /**
   * 操作类型
   */
  @Column(name = "operation_type", nullable = false, length = 8, columnDefinition = "VARCHAR(8) COMMENT '操作类型'")
  @ApiModelProperty(value = "操作类型")
  private String operationType;
  /**
   * 来源编号
   */
  @Column(name = "from_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '来源编号'")
  @ApiModelProperty(value = "来源编号")
  private String fromCode;
  /**
   * 来源描述
   */
  @Column(name = "from_desc", length = 64, columnDefinition = "VARCHAR(64) COMMENT '来源描述'")
  @ApiModelProperty(value = "来源描述")
  private String fromDesc;
  /**
   * 上账时间
   */
  @Column(name = "account_date_time", nullable = false, columnDefinition = "datetime COMMENT '上账时间 yyyy-MM-dd HH:mm:ss'")
  @ApiModelProperty(value = "上账时间")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date accountDateTime;
  /**
   * 总金额（数量）
   */
  @Column(name = "total_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '总金额（数量）'")
  @ApiModelProperty(value = "总金额")
  private BigDecimal totalAmount;
  /**
   * 冻结金额（数量）
   */
  @Column(name = "freeze_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '冻结金额（数量）'")
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal freezeAmount;
  /**
   * 占用金额（数量）
   */
  @Column(name = "occupy_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '占用金额（数量）'")
  @ApiModelProperty(value = "占用金额")
  private BigDecimal occupyAmount;
  /**
   * 已使用金额（数量）
   */
  @Column(name = "has_use_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '已使用金额（数量）'")
  @ApiModelProperty(value = "已使用金额")
  private BigDecimal hasUseAmount;
  /**
   * 剩余可使用金额（数量）
   */
  @Column(name = "usable_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '剩余可使用金额（数量）'")
  @ApiModelProperty(value = "剩余可使用金额")
  private BigDecimal usableAmount;
  /**
   * 附件信息集合
   */
  @Transient
  @ApiModelProperty("附件信息集合")
  @TableField(exist = false)
  private Set<CostPoolReplenishmentFile> costPoolDiscountFiles;
  /**
   * 货补费用池主表
   */
  @Transient
  @ApiModelProperty("货补费用池主表信息")
  @TableField(exist = false)
  private CostPoolReplenishment costPoolReplenishment;
}