package com.biz.crm.dms.business.costpool.replenishment.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author HanJiaJun
 * @describe:货补费用池附件表
 * @createTime 2021年12月27日 17:27:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("dms_cost_pool_replenishment_file")
@Entity
@Table(name = "dms_cost_pool_replenishment_file", indexes = {
    @Index(name = "i_f_file_pool_code", columnList = "pool_code"),
    @Index(name = "i_f_file_operation_code", columnList = "operation_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_cost_pool_replenishment_file", comment = "货补费用池附件表")
public class CostPoolReplenishmentFile extends UuidEntity {
  /**
   * 费用池编号
   */
  @Column(name = "pool_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池编号'")
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 操作记录编号
   */
  @Column(name = "operation_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作记录编号'")
  @ApiModelProperty(value = "操作记录编号")
  private String operationCode;
  /**
   * 文件名称
   */
  @Column(name = "file_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '文件名称'")
  @ApiModelProperty(value = "文件名称")
  private String fileName;
  /**
   * 文件路径
   */
  @Column(name = "url", nullable = false, length = 500, columnDefinition = "VARCHAR(500) COMMENT '文件路径'")
  @ApiModelProperty(value = "文件路径")
  private String url;

}
