package com.biz.crm.dms.business.costpool.replenishment.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * @author HanJiaJun
 * @describe: 货补池产品
 * @createTime 2022年01月17日 17:19:00
 */

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("dms_cost_pool_replenishment_product")
@Entity
@Table(name = "dms_cost_pool_replenishment_product", indexes = {@Index(name = "i_l_pool_code", columnList = "pool_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_cost_pool_replenishment_product", comment = "货补费用池产品表")
public class CostPoolReplenishmentProduct extends UuidEntity {

  /**
   * 费用池编号
   */
  @Column(name = "pool_code", nullable = false, length = 64, columnDefinition = "VARCHAR(32) COMMENT '费用池编号'")
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 货补产品层级编码
   */
  @Column(name = "product_level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '货补产品层级编码'")
  @ApiModelProperty(value = "货补产品层级编码")
  private String productLevelCode;
  /**
   * 货补商品编码
   */
  @Column(name = "goods_product_code", length = 255, columnDefinition = "VARCHAR(255) COMMENT '货补商品编码'")
  @ApiModelProperty(value = "货补商品编码")
  private String goodsProductCode;
  /**
   * 货补商品名称
   */
  @Column(name = "goods_product_name", length = 500, columnDefinition = "VARCHAR(500) COMMENT '货补商品名称'")
  @ApiModelProperty(value = "货补商品名称")
  private String goodsProductName;
}
