package com.biz.crm.dms.business.costpool.replenishment.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOrderPageDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 货补费用池主表(CostPoolReplenishment)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
public interface CostPoolReplenishmentMapper extends BaseMapper<CostPoolReplenishment> {

  /**
   * 分页查询所有数据
   *
   * @param page                  分页对象
   * @param costPoolReplenishment 查询实体
   * @return 所有数据
   */
  public Page<CostPoolReplenishment> findByConditions(@Param("page") Page<CostPoolReplenishment> page, @Param("costPoolReplenishment") CostPoolReplenishmentDto costPoolReplenishment);

  /**
   * 按条件查询数据，关联产品子表
   * @param costPoolReplenishmentDto
   * @return
   */
  public List<CostPoolReplenishment> findByCostPoolReplenishmentDto(@Param("costPoolReplenishment")CostPoolReplenishmentDto costPoolReplenishmentDto);

  /**
   * 新增订单 新增货补商品查询接口
   * @param page
   * @param costPoolReplenishmentOrderPageDto
   * @return
   */
  public Page<CostPoolReplenishmentOrderVo> findByReplenishmentPageDto(Page<CostPoolReplenishment> page,@Param("dto") CostPoolReplenishmentOrderPageDto costPoolReplenishmentOrderPageDto);
}

