package com.biz.crm.dms.business.costpool.replenishment.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentFileMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;


/**
 * 货补费用池附件表(CostPoolReplenishmentFile)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Component
public class CostPoolReplenishmentFileRepository extends ServiceImpl<CostPoolReplenishmentFileMapper, CostPoolReplenishmentFile> {

  @Autowired(required = false)
  private CostPoolReplenishmentFileMapper costPoolReplenishmentFileMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolReplenishmentFile 实体对象
   * @return
   */
  public Page<CostPoolReplenishmentFile> findByConditions(Pageable pageable, CostPoolReplenishmentFile costPoolReplenishmentFile) {
    Page<CostPoolReplenishmentFile> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolReplenishmentFile> pageList = costPoolReplenishmentFileMapper.findByConditions(page, costPoolReplenishmentFile);
    return pageList;
  }

}

