package com.biz.crm.dms.business.costpool.replenishment.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentOperationMapper;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOperationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 货补费用池操作记录表(CostPoolReplenishmentOperation)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Component
public class CostPoolReplenishmentOperationRepository extends ServiceImpl<CostPoolReplenishmentOperationMapper, CostPoolReplenishmentOperation> {

  @Autowired(required = false)
  private CostPoolReplenishmentOperationMapper costPoolReplenishmentOperationMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentOperation 实体对象
   * @return
   */
  public Page<CostPoolReplenishmentOperation> findByConditions(Pageable pageable, CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    Page<CostPoolReplenishmentOperation> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolReplenishmentOperation> pageList = costPoolReplenishmentOperationMapper.findByConditions(page, costPoolReplenishmentOperation);
    return pageList;
  }

  /**
   * 客户-货补操作明细分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<CostPoolReplenishmentOperationVo> findByCostPoolReplenishmentOperationDto(Page<CostPoolReplenishmentOperationVo> page, CostPoolReplenishmentOperationDto dto) {
    return this.costPoolReplenishmentOperationMapper.findByCostPoolReplenishmentOperationDto(page, dto);
  }

  /**
   * 根据费用池编码集合和时间查询  时间包括等于
   *
   * @param dto
   * @return
   */
  public List<CostPoolReplenishmentOperation> findByPoolCodesAndDate(CostPoolReplenishmentOperationDto dto) {
    return this.costPoolReplenishmentOperationMapper.findByPoolCodesAndDate(dto);
  }

  /**
   * 根据费用池编码集合和开始时间 查询 开始时间之前的记录
   *
   * @param dto
   * @return
   */
  public List<CostPoolReplenishmentOperation> findByPoolCodesAndBeforeDate(CostPoolReplenishmentOperationDto dto) {
    return this.lambdaQuery()
        .in(CostPoolReplenishmentOperation::getPoolCode, dto.getPoolCodeList())
        .lt(CostPoolReplenishmentOperation::getOperationDateTime, dto.getStartTime())
        .list();
  }
}

