package com.biz.crm.dms.business.costpool.replenishment.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentMapper;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOrderPageDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年03月08日 17:44:00
 */
@Component
public class CostPoolReplenishmentOrderVoRepository extends ServiceImpl<CostPoolReplenishmentMapper, CostPoolReplenishment> {

  @Autowired(required = false)
  private CostPoolReplenishmentMapper costPoolReplenishmentMapper;

  /**
   * 分页查询
   *
   * @param pageable
   * @param
   * @return
   */
  public Page<CostPoolReplenishmentOrderVo> findByReplenishmentPageDto(Pageable pageable, CostPoolReplenishmentOrderPageDto costPoolReplenishmentOrderPageDto) {
    Page<CostPoolReplenishment> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolReplenishmentOrderVo> voByConditions = costPoolReplenishmentMapper.findByReplenishmentPageDto(page, costPoolReplenishmentOrderPageDto);
    return voByConditions;
  }
}
